<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

session_start();
// Redirect to login if not authenticated
if (!isset($_SESSION['user_id'])) {
    header("Location: index.php");
    exit();
}

// Assuming you're connected to the database
include("connect.php");

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Getting values from POST request
    $userBalance = $_POST["userBalance"];  // The current balance of the user
    $userId = $_SESSION["user_id"];  // Assuming user_id is stored in session
    $number = $_POST["number"];  // Other data (transaction-related)
    $amount = $_POST["amount"];  // Amount to deposit
    $method = $_POST["method"];  // Method (e.g., bank transfer, PayPal, etc.)
    $bank_name = isset($_POST["bank_name"]) ? $_POST["bank_name"] : ''; // Bank name if selected

    // Check if the amount is greater than 5000
    if ($amount > 4999) {
        // Check if the amount is less than or equal to the user balance
        if ($amount <= $userBalance) {
            // Process the deposit (Insert transaction into database)
            // First check if bank_name column exists
            $check_column = mysqli_query($conn, "SHOW COLUMNS FROM `widthrow` LIKE 'bank_name'");
            $column_exists = (mysqli_num_rows($check_column)) > 0;
            
            if ($column_exists) {
                $sql = "INSERT INTO `widthrow` (`userid`, `number`, `amount`, `methord`, `bank_name`, `time`, `status`) 
                        VALUES ('$userId', '$number', '$amount', '$method', " . ($bank_name ? "'$bank_name'" : "NULL") . ", NOW(), 'pending')";
            } else {
                // If bank_name column doesn't exist, insert without it
                $sql = "INSERT INTO `widthrow` (`userid`, `number`, `amount`, `methord`, `time`, `status`) 
                        VALUES ('$userId', '$number', '$amount', '$method', NOW(), 'pending')";
            }

            $quary = mysqli_query($conn, $sql);

            if ($quary) {
                // Update user balance after the deposit is processed
                $update_user_balance = "UPDATE `user` SET `Balancer` = `Balancer` - $amount WHERE `id` = '$userId'";
                $update_query = mysqli_query($conn, $update_user_balance);

                if ($update_query) {
                    // Update the session balance
                    $_SESSION['Balancer'] -= $amount;

                    // Redirect to the widthrowhistory page with a success status
                    header("Location: widthrowhistory.php?status=success");
                    exit();
                } else {
                    // If updating balance fails, show an error toast
                    $toast_message = "Error updating balance. Please try again.";
                    $toast_type = "error";
                }
            } else {
                // If inserting into widthrow fails, show an error toast
                $toast_message = "Error processing your request. Please try again.";
                $toast_type = "error";
            }
        } else {
            // If the amount is greater than the user's balance, show an error toast
            $toast_message = "Insufficient balance for this withdrawal.";
            $toast_type = "error";
        }
    } else {
        // If the amount is not greater than 5000, show an error toast
        $toast_message = "The withdrawal amount must be greater than 5000.";
        $toast_type = "error";
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>Bank loan - Trusted service - Withdraw Money</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.2.0/css/all.min.css">
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Kanit:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        * {
            font-family: 'Kanit', sans-serif;
            -webkit-touch-callout: none;
            -webkit-user-select: none;
            -moz-user-select: none;
            user-select: none;
            box-sizing: border-box;
        }
        
        .payment-card {
            transition: all 0.3s ease;
            border: 2px solid transparent;
            position: relative;
            overflow: hidden;
            min-width: 110px;
        }
        
        .payment-card::before {
            content: '';
            position: absolute;
            top: -50%;
            left: -50%;
            width: 200%;
            height: 200%;
            background: linear-gradient(
                to bottom right,
                rgba(255, 255, 255, 0.3),
                rgba(255, 255, 255, 0)
            );
            transform: rotate(30deg);
            transition: all 0.5s ease;
        }
        
        .payment-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 20px rgba(0, 0, 0, 0.1);
        }
        
        .payment-card:hover::before {
            left: 100%;
        }
        
        .payment-card.active {
            border-color: white;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.2);
            transform: scale(1.02);
        }
        
        .payment-card.active::after {
            content: '✓';
            position: absolute;
            top: 5px;
            right: 5px;
            width: 20px;
            height: 20px;
            background: white;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: bold;
        }
        
        .bkash-card {
            background: linear-gradient(135deg, #E2136E 0%, #B72B41 100%);
            color: white;
            border-color: #B72B41;
        }
        
        .bkash-card.active::after {
            color: #B72B41;
        }
        
        .nagad-card {
            background: linear-gradient(135deg, #E30B17 0%, #E30B5C 100%);
            color: white;
            border-color: #E30B17;
        }
        
        .nagad-card.active::after {
            color: #E30B17;
        }
        
        .bank-card {
            background: linear-gradient(135deg, #2475c9 0%, #1a4b8c 100%);
            color: white;
            border-color: #2475c9;
        }
        
        .bank-card.active::after {
            color: #2475c9;
        }
        
        .bkash-input {
            border-color: #B72B41;
            box-shadow: 0 0 0 1px #B72B41;
        }
        
        .nagad-input {
            border-color: #E30B17;
            box-shadow: 0 0 0 1px #E30B17;
        }
        
        .bank-input {
            border-color: #2475c9;
            box-shadow: 0 0 0 1px #2475c9;
        }
        
        .input-section {
            transition: all 0.3s ease;
            animation: fadeIn 0.5s ease-out;
        }
        
        .balance-card {
            background: linear-gradient(135deg, #4CAF50 0%, #2E7D32 100%);
            color: white;
            box-shadow: 0 4px 15px rgba(76, 175, 80, 0.3);
            transition: all 0.3s ease;
        }
        
        .balance-card:hover {
            transform: translateY(-3px);
            box-shadow: 0 6px 20px rgba(76, 175, 80, 0.4);
        }
        
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(10px); }
            to { opacity: 1; transform: translateY(0); }
        }
        
        .btn-gold {
            background: linear-gradient(135deg, #F6BE00 0%, #e0ac00 100%);
            color: white;
            transition: all 0.3s ease;
            box-shadow: 0 4px 15px rgba(246, 190, 0, 0.3);
        }
        
        .btn-gold:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(246, 190, 0, 0.4);
        }
        
        .notice-card {
            border-left: 4px solid #F6BE00;
            animation: pulse 2s infinite;
        }
        
        @keyframes pulse {
            0% { box-shadow: 0 0 0 0 rgba(246, 190, 0, 0.4); }
            70% { box-shadow: 0 0 0 10px rgba(246, 190, 0, 0); }
            100% { box-shadow: 0 0 0 0 rgba(246, 190, 0, 0); }
        }
        
        .payment-methods-container {
            display: flex;
            overflow-x: auto;
            scroll-snap-type: x mandatory;
            gap: 10px;
            padding: 10px 0;
            -webkit-overflow-scrolling: touch;
        }
        
        .payment-methods-container::-webkit-scrollbar {
            display: none;
        }
        
        .payment-method-item {
            scroll-snap-align: start;
            flex: 0 0 auto;
        }
        
        @media (min-width: 640px) {
            .payment-methods-container {
                justify-content: center;
                overflow-x: visible;
                flex-wrap: wrap;
            }
        }
    </style>
</head>
<body class="bg-gray-100">

<div class="min-h-screen pb-10">
    <!-- Header -->
    <div class="h-14 w-full bg-[#F6BE00] pl-4 gap-5 shadow-lg text-white flex items-center sticky top-0 z-10">
        <a href="dashboard.php" class="flex items-center">
            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor" class="h-7 font-bold cursor-pointer w-7">
                <path fill-rule="evenodd" d="M7.72 12.53a.75.75 0 010-1.06l7.5-7.5a.75.75 0 111.06 1.06L9.31 12l6.97 6.97a.75.75 0 11-1.06 1.06l-7.5-7.5z" clip-rule="evenodd"></path>
            </svg>
            <h2 class="text-xl text-white font-bold ml-2">Withdraw</h2>
        </a>
    </div>
    
    <!-- Notice -->
    <div class="mx-4 my-3 p-3 bg-white rounded-lg shadow-lg notice-card">
        <div class="flex items-center">
            <i class="fas fa-info-circle text-[#F6BE00] text-lg mr-2"></i>
            <p class="text-sm font-medium">নোটিশ: মিনিমাম উইথড্র 5000 টাকা। উইথড্র দেয়ার সাথে সাথে অটোম্যাটিকভাবে পেমেন্ট পেয়ে যাবেন।</p>
        </div>
    </div>
    
    <!-- Balance -->
    <div class="flex gap-3 items-center justify-between mx-4 my-3 p-4 rounded-lg shadow-lg balance-card">
        <div class="flex items-center">
            <i class="fas fa-wallet text-white text-xl mr-2"></i>
            <h2 class="text-lg text-white">Balance:</h2>
        </div>
        <h2 class="text-white text-xl font-bold"><?php echo number_format($_SESSION['Balancer'], 2)?> ৳</h2>
    </div>

    <form action="withdraw.php" method="post" onsubmit="return validateForm()">
        <input type="hidden" name="userBalance" value="<?php echo $_SESSION['Balancer']?>" id="_token">
        <input type="hidden" id="selected_payment_method" name="method" value="">

        <!-- Payment Methods - Horizontal Scroll on Mobile -->
        <div class="mx-4 my-3 p-4 bg-white rounded-lg shadow-lg">
            <h2 class="mb-3 text-lg font-semibold text-gray-700 flex items-center">
                <i class="fas fa-credit-card mr-2 text-[#F6BE00]"></i>
                Select Payment Method
            </h2>
            
            <div class="payment-methods-container">
                <!-- Bkash Card -->
                <div class="payment-method-item">
                    <div class="payment-card bkash-card p-3 rounded-lg cursor-pointer text-center"
                         data-method="Bkash" onclick="selectPaymentMethod(this, 'Bkash')">
                        <img src="/images/d-siam/payment.png" alt="Bkash" class="h-12 w-12 mx-auto mb-1">
                        <h3 class="font-bold text-sm">বিকাশ</h3>
                        <p class="text-xs opacity-90">Min: 5,000৳</p>
                        <p class="text-xs opacity-90">Max: 25,000৳</p>
                    </div>
                </div>
                
                <!-- Nagad Card -->
                <div class="payment-method-item">
                    <div class="payment-card nagad-card p-3 rounded-lg cursor-pointer text-center"
                         data-method="Nagad" onclick="selectPaymentMethod(this, 'Nagad')">
                        <img src="/images/d-siam/payment.png" alt="Nagad" class="h-12 w-12 mx-auto mb-1">
                        <h3 class="font-bold text-sm">নগদ</h3>
                        <p class="text-xs opacity-90">Min: 5,000৳</p>
                        <p class="text-xs opacity-90">Max: 25,000৳</p>
                    </div>
                </div>
                
                <!-- Bank Card -->
                <div class="payment-method-item">
                    <div class="payment-card bank-card p-3 rounded-lg cursor-pointer text-center"
                         data-method="Bank" onclick="selectPaymentMethod(this, 'Bank')">
                        <img src="/images/d-siam/payment.png" alt="Bank" class="h-12 w-12 mx-auto mb-1">
                        <h3 class="font-bold text-sm">ব্যাংক</h3>
                        <p class="text-xs opacity-90">Min: 5,000৳</p>
                        <p class="text-xs opacity-90">Max: 100,000৳</p>
                    </div>
                </div>
            </div>
            
            <!-- Bank Select (Hidden by default) -->
            <div id="bank_select_container" class="w-full mt-3 hidden">
                <select class="w-full p-2 border rounded-lg shadow-sm focus:outline-none focus:ring-2 focus:ring-blue-500" 
                        name="bank_name" id="bank_name">
                    <option value="">Select Bank</option>
                    <!-- Bangladesh Banks -->
                    <optgroup label="Bangladesh Banks">
                        <option value="Sonali Bank">Sonali Bank</option>
                        <option value="Janata Bank">Janata Bank</option>
                        <option value="Agrani Bank">Agrani Bank</option>
                        <option value="Islami Bank Bangladesh">Islami Bank Bangladesh</option>
                        <option value="Dutch-Bangla Bank">Dutch-Bangla Bank</option>
                        <option value="BRAC Bank">BRAC Bank</option>
                    </optgroup>
                    
                    <!-- International Banks -->
                    <optgroup label="International Banks">
                        <option value="Al Rajhi Bank">Al Rajhi Bank (Saudi)</option>
                        <option value="Qatar National Bank">Qatar National Bank</option>
                        <option value="Emirates NBD">Emirates NBD (UAE)</option>
                        <option value="Maybank">Maybank (Malaysia)</option>
                    </optgroup>
                </select>
            </div>
        </div>

        <!-- Account Number Input -->
        <div id="account_input_section" class="input-section mx-4 my-3 p-4 bg-white rounded-lg shadow-lg hidden">
            <h2 class="mb-2 text-md font-semibold text-gray-700 flex items-center" id="account_label">
                <i class="fas fa-user-circle mr-2 text-[#F6BE00] text-sm"></i>
                <span>Account Number</span>
            </h2>
            <div class="flex w-full items-center border rounded-lg overflow-hidden bg-gray-50" id="account_input_container">
                <div class="h-10 w-10 flex items-center justify-center border-r bg-gray-100">
                    <i class="fas fa-mobile-alt text-gray-600 text-lg"></i>
                </div>
                <input name="number" required placeholder="Enter account number" type="text" 
                       class="w-full h-10 px-2 outline-none bg-transparent text-sm" id="number">
            </div>
        </div>

        <!-- Amount Input -->
        <div id="amount_input_section" class="input-section mx-4 my-3 p-4 bg-white rounded-lg shadow-lg hidden">
            <h2 class="mb-2 text-md font-semibold text-gray-700 flex items-center">
                <i class="fas fa-money-bill-wave mr-2 text-[#F6BE00] text-sm"></i>
                Amount
            </h2>
            <div class="flex w-full items-center border rounded-lg overflow-hidden bg-gray-50" id="amount_input_container">
                <div class="h-10 w-10 flex items-center justify-center border-r bg-gray-100">
                    <i class="fas fa-taka-sign text-gray-600 text-lg"></i>
                </div>
                <input required placeholder="Enter amount (Min: 5,000৳)" name="amount" type="number" 
                       class="w-full h-10 px-2 outline-none bg-transparent text-sm" id="amount">
            </div>
            <p class="text-red-500 text-xs mt-1 flex items-center">
                <i class="fas fa-exclamation-circle mr-1"></i>
                Minimum withdraw 5,000 BDT
            </p>
        </div>

        <!-- Submit Button -->
        <div class="mx-4 my-4">
            <button type="submit" class="w-full py-3 px-4 text-white font-bold rounded-full btn-gold text-sm">
                <i class="fas fa-paper-plane mr-2"></i>
                Withdraw Now
            </button>
        </div>
    </form>
</div>

<script>
    <?php if (!empty($toast_message)): ?>
    document.addEventListener('DOMContentLoaded', function() {
        alert("<?php echo $toast_message; ?>");
    });
    <?php endif; ?>

    // Auto-select Bkash by default
    document.addEventListener('DOMContentLoaded', function() {
        const bkashCard = document.querySelector('[data-method="Bkash"]');
        selectPaymentMethod(bkashCard, 'Bkash');
    });

    // Select payment method and update UI
    function selectPaymentMethod(element, method) {
        // Remove active class from all cards
        document.querySelectorAll('.payment-card').forEach(card => {
            card.classList.remove('active');
        });
        
        // Add active class to selected card
        element.classList.add('active');
        
        // Set the selected method in hidden input
        document.getElementById('selected_payment_method').value = method;
        
        // Show input sections with animation
        document.getElementById('account_input_section').classList.remove('hidden');
        document.getElementById('amount_input_section').classList.remove('hidden');
        
        // Update UI based on selected method
        const accountInput = document.getElementById('number');
        const accountContainer = document.getElementById('account_input_container');
        const amountContainer = document.getElementById('amount_input_container');
        const accountLabel = document.getElementById('account_label');
        
        // Reset all styles first
        accountContainer.className = 'flex w-full items-center border rounded-lg overflow-hidden bg-gray-50';
        amountContainer.className = 'flex w-full items-center border rounded-lg overflow-hidden bg-gray-50';
        
        if (method === 'Bkash') {
            // Bkash style
            accountLabel.innerHTML = '<i class="fas fa-mobile-alt mr-2 text-[#F6BE00] text-sm"></i><span>Bkash Number</span>';
            accountInput.placeholder = 'Enter Bkash number (01XXXXXXXXX)';
            accountContainer.classList.add('bkash-input');
            amountContainer.classList.add('bkash-input');
            
            // Hide bank selection
            document.getElementById('bank_select_container').classList.add('hidden');
        } else if (method === 'Nagad') {
            // Nagad style
            accountLabel.innerHTML = '<i class="fas fa-mobile-alt mr-2 text-[#F6BE00] text-sm"></i><span>Nagad Number</span>';
            accountInput.placeholder = 'Enter Nagad number (01XXXXXXXXX)';
            accountContainer.classList.add('nagad-input');
            amountContainer.classList.add('nagad-input');
            
            // Hide bank selection
            document.getElementById('bank_select_container').classList.add('hidden');
        } else if (method === 'Bank') {
            // Bank style
            accountLabel.innerHTML = '<i class="fas fa-university mr-2 text-[#F6BE00] text-sm"></i><span>Bank Account</span>';
            accountInput.placeholder = 'Enter bank account number';
            accountContainer.classList.add('bank-input');
            amountContainer.classList.add('bank-input');
            
            // Show bank selection with animation
            document.getElementById('bank_select_container').classList.remove('hidden');
        }
    }
    
    // Validate form before submission
    function validateForm() {
        const method = document.getElementById('selected_payment_method').value;
        const number = document.getElementById('number').value;
        const amount = parseFloat(document.getElementById('amount').value);
        const userBalance = parseFloat(document.getElementById('_token').value);
        const bankName = document.getElementById('bank_name').value;

        if (!method) {
            alert('Please select a payment method');
            return false;
        }

        if (method === 'Bank' && !bankName) {
            alert('Please select a bank');
            return false;
        }

        if (method === 'Bkash' || method === 'Nagad') {
            if (!number || !/^01[3-9]\d{8}$/.test(number)) {
                alert('Please enter a valid mobile number (11 digits starting with 01)');
                return false;
            }
        } else if (method === 'Bank') {
            if (!number) {
                alert('Please enter a valid bank account number');
                return false;
            }
        }

        if (!amount || amount < 4999) {
            alert('Minimum withdrawal amount is 5000 BDT');
            return false;
        }

        if (amount > userBalance) {
            alert('Insufficient balance for this withdrawal');
            return false;
        }

        return true;
    }
</script>

</body>
</html>

<!-- ========User-Panel-Section Ends Here ========-->
<!-- Modal -->
<!-- Footer Navigation Start -->
<style>
  .footer {
    position: fixed;
    bottom: 0;
    width: 100%;
    background: rgba(15, 32, 39, 0.95);
    backdrop-filter: blur(4px);
    color: white;
    padding: 10px 0;
    box-shadow: 0 -4px 20px rgba(0, 0, 0, 0.4);
    z-index: 999;
    transition: background 0.3s ease;
  }
  .footer.scrolled {
    background: rgba(15, 32, 39, 0.8);
  }
  .footer .row {
    display: flex;
    justify-content: space-around;
    align-items: center;
    text-align: center;
    max-width: 1000px;
    margin: 0 auto;
    padding: 0 20px;
    flex-wrap: wrap;
  }
  .footer .col {
    flex: 1 1 25%;
    min-width: 70px;
    margin: 5px 0;
  }
  .footer .col a {
    display: flex;
    flex-direction: column;
    align-items: center;
    text-decoration: none;
    color: white;
    transition: transform 0.3s;
  }
  .footer .col a:hover {
    transform: scale(1.1);
  }
  .footer-icon {
    width: 48px;
    height: 48px;
    object-fit: contain;
    transition: all 0.3s ease-in-out;
    filter: drop-shadow(0 4px 8px rgba(0,0,0,0.4));
  }
  .footer p {
    margin: 4px 0 0;
    font-size: 14px;
  }
  .footer .col:nth-child(1) img {
    animation: float1 4s ease-in-out infinite;
    filter: drop-shadow(0 5px 12px rgba(255, 111, 0, 0.4));
  }
  .footer .col:nth-child(2) img {
    animation: float2 5s ease-in-out infinite;
    filter: drop-shadow(0 5px 12px rgba(37, 211, 102, 0.5));
  }
  .footer .col:nth-child(3) img {
    animation: float3 4.5s ease-in-out infinite;
    filter: drop-shadow(0 5px 12px rgba(255, 255, 0, 0.5));
  }
  .footer .col:nth-child(4) img {
    animation: float4 5.2s ease-in-out infinite;
    filter: drop-shadow(0 5px 12px rgba(0, 123, 255, 0.5));
  }
  @keyframes float1 {
    0% { transform: translateY(0px) rotateZ(0deg); }
    50% { transform: translateY(-4px) rotateZ(1deg); }
    100% { transform: translateY(0px) rotateZ(0deg); }
  }
  @keyframes float2 {
    0% { transform: translateY(0px) rotateZ(0deg); }
    50% { transform: translateY(-3px) rotateZ(-1deg); }
    100% { transform: translateY(0px) rotateZ(0deg); }
  }
  @keyframes float3 {
    0% { transform: translateY(0px) rotateZ(0deg); }
    50% { transform: translateY(-5px) rotateZ(1deg); }
    100% { transform: translateY(0px) rotateZ(0deg); }
  }
  @keyframes float4 {
    0% { transform: translateY(0px) rotateZ(0deg); }
    50% { transform: translateY(-3px) rotateZ(-1.5deg); }
    100% { transform: translateY(0px) rotateZ(0deg); }
  }
  @media (max-width: 768px) {
    .footer-icon {
      width: 38px;
      height: 38px;
    }
    .footer p {
      font-size: 12px;
    }
  }
  @media (max-width: 480px) {
    .footer .row {
      flex-direction: row;
      justify-content: space-between;
      padding: 0 10px;
    }
    .footer-icon {
      width: 32px;
      height: 32px;
    }
    .footer p {
      font-size: 11px;
    }
    .footer .col {
      flex: 1 1 22%;
    }
  }
</style>

<div class="footer" id="footer">
  <div class="row">
    <!-- Home -->
    <div class="col">
      <a href="/">
        <img class="footer-icon" src="/images/footer/home.png" alt="Home">
        <p>Home</p>
      </a>
    </div>
    <!-- WhatsApp -->
    <div class="col">
      <a href="https://wa.me/your-number" target="_blank">
        <img class="footer-icon" src="/images/footer/whatsapp.png" alt="WhatsApp">
        <p>WhatsApp</p>
      </a>
    </div>
    <!-- Profile -->
    <div class="col">
      <a href="profile.php">
        <img class="footer-icon" src="/images/footer/user-4.png" alt="Profile">
        <p>Profile</p>
      </a>
    </div>
    <!-- logout -->
    <div class="col">
      <a href="logout.php">
        <img class="footer-icon" src="/images/footer/logout-2.png" alt="logout">
        <p>logout</p>
      </a>
    </div>
  </div>
</div>

<script>
  const footer = document.getElementById('footer');
  window.addEventListener('scroll', () => {
    if (window.scrollY > 10) {
      footer.classList.add('scrolled');
    } else {
      footer.classList.remove('scrolled');
    }
  });
</script>
    <br>
<br>

<!-- Footer Navigation End -->