<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

session_start();

if(!isset($_SESSION["logged_in"]) || $_SESSION["logged_in"] !== true) {
    header("location: login.php");
    exit();
}

include ("connect.php");

// Function to check transaction ID
function checkTransactionExists($conn, $transaction_id) {
    $stmt = $conn->prepare("SELECT status FROM deposits WHERE trx_id = ?");
    $stmt->bind_param("s", $transaction_id);
    $stmt->execute();
    $result = $stmt->get_result();
    
    if($result->num_rows > 0) {
        $row = $result->fetch_assoc();
        return $row['status']; // Returns status (pending/approved/rejected)
    }
    return false; // Transaction doesn't exist
}

// Handle form submission
if (isset($_POST["transaction_id"])) {
    // Collect form data
    $userid = $_POST["userid"];
    $transaction_id = trim($_POST["transaction_id"]);
    $name = $_POST["name"];
    $phoneNumber = $_POST["phoneNumber"];
    $amount = $_POST["amount"];
    $paymentNumber = $_POST["paymentNumber"];
    $method = $_POST["methord"];

    // 1. First check if transaction ID already exists
    $existingStatus = checkTransactionExists($conn, $transaction_id);
    
    if($existingStatus !== false) {
        // Transaction exists case
        switch($existingStatus) {
            case 'pending':
                $_SESSION['flash_message'] = [
                    'type' => 'warning',
                    'text' => 'এই ট্রানজেকশন নম্বরটি ইতিমধ্যে পেন্ডিং অবস্থায় আছে! অনুগ্রহ করে অ্যাডমিনের অনুমোদনের জন্য অপেক্ষা করুন।',
                    'duration' => 5000
                ];
                break;
            case 'approved':
                $_SESSION['flash_message'] = [
                    'type' => 'error',
                    'text' => 'এই ট্রানজেকশন নম্বরটি ইতিমধ্যে অ্যাপ্রুভ করা হয়েছে! একই ট্রানজেকশন নম্বর দিয়ে পুনরায় ডিপোজিট করা সম্ভব নয়।',
                    'duration' => 5000
                ];
                break;
            case 'rejected':
                $_SESSION['flash_message'] = [
                    'type' => 'error',
                    'text' => 'এই ট্রানজেকশন নম্বরটি রিজেক্ট হয়েছে! অনুগ্রহ করে নতুন ট্রানজেকশন নম্বর ব্যবহার করুন অথবা কাস্টমার সার্ভিসে যোগাযোগ করুন।',
                    'duration' => 5000
                ];
                break;
            default:
                $_SESSION['flash_message'] = [
                    'type' => 'error',
                    'text' => 'এই ট্রানজেকশন নম্বরটি ইতিমধ্যে অ্যাপ্রুভ করা হয়েছে! একই ট্রানজেকশন নম্বর দিয়ে পুনরায় ডিপোজিট করা সম্ভব নয়।',
                    'duration' => 5000
                ];
        }
        header("Location: manual.php");
        exit();
    }
    // 2. Process new transaction
    // Handle front image upload
    $frontImageUrl = 'default_image_url'; // Default image
    
    if (isset($_FILES['front_id']) && $_FILES['front_id']['error'] === 0) {
        $uploadDirectory = "uploads/";
        $frontFileName = $_FILES['front_id']['name'];
        $frontFileTmpName = $_FILES['front_id']['tmp_name'];
        $frontFileExtension = strtolower(pathinfo($frontFileName, PATHINFO_EXTENSION));
        
        $allowed = array('jpg', 'jpeg', 'png', 'gif');
        
        if (in_array($frontFileExtension, $allowed)) {
            $frontFileNewName = uniqid('', true) . '.' . $frontFileExtension;
            $frontFileDestination = $uploadDirectory . $frontFileNewName;
            
            if (move_uploaded_file($frontFileTmpName, $frontFileDestination)) {
                $frontImageUrl = $frontFileDestination;
            } else {
                $_SESSION['flash_message'] = [
                    'type' => 'error',
                    'text' => 'আপনার ফ্রন্ট আইডি ইমেজ আপলোড করতে সমস্যা হয়েছে! অনুগ্রহ করে আবার চেষ্টা করুন।',
                    'duration' => 5000
                ];
                header("Location: manual.php");
                exit();
            }
        } else {
            $_SESSION['flash_message'] = [
                'type' => 'error',
                'text' => 'শুধুমাত্র JPG, JPEG, PNG, GIF ফরম্যাটের ইমেজ ফাইল অনুমোদিত!',
                'duration' => 5000
            ];
            header("Location: manual.php");
            exit();
        }
    }

    // 3. Insert deposit record into database
    date_default_timezone_set('Asia/Dhaka');
    
    $stmt = $conn->prepare("
        INSERT INTO `deposits` 
        (`userid`, `method`, `to_number`, `from_number`, `amount`, `trx_id`, `front_id_url`, `created_at`, `status`) 
        VALUES (?, ?, ?, ?, ?, ?, ?, NOW(), 'pending')
    ");
    
    $stmt->bind_param(
        "issssss", 
        $userid, 
        $method, 
        $phoneNumber, 
        $paymentNumber, 
        $amount, 
        $transaction_id, 
        $frontImageUrl
    );
    
    if ($stmt->execute()) {
        $_SESSION['flash_message'] = [
            'type' => 'success',
            'text' => 'আপনার ডিপোজিট রিকোয়েস্ট সফলভাবে জমা হয়েছে! অ্যাডমিন অনুমোদনের জন্য অপেক্ষা করুন।',
            'duration' => 5000
        ];
        header("Location: deposithistory.php");
    } else {
        $_SESSION['flash_message'] = [
            'type' => 'error',
            'text' => 'ডাটাবেসে সেভ করতে সমস্যা হয়েছে! অনুগ্রহ করে আবার চেষ্টা করুন।',
            'duration' => 5000
        ];
        header("Location: manual.php");
    }
    
    $stmt->close();
    exit();
}

// Get payment method and amount from POST or SESSION to maintain data on refresh
$payment_method = $_POST['payment_method'] ?? $_SESSION['payment_method'] ?? null;
$amount = $_POST['amount'] ?? $_SESSION['amount'] ?? null;

// Store in session to maintain data
$_SESSION['payment_method'] = $payment_method;
$_SESSION['amount'] = $amount;

// Fetch payment info from database
$payment_info = [];
$sql_query = mysqli_query($conn, "SELECT * FROM `paymnetnumber` ORDER BY id DESC LIMIT 1");
if ($sql_query) {
    $payment_info = mysqli_fetch_assoc($sql_query);
}

// Determine payment method name and number
$method_names = [
    1000 => ['name' => 'বিকাশ', 'field' => 'bkash'],
    1001 => ['name' => 'নগদ', 'field' => 'nagad'],
    1002 => ['name' => 'রকেট', 'field' => 'roket']
];

$current_method = $method_names[$payment_method] ?? null;
$payment_number = $current_method ? $payment_info[$current_method['field']] ?? '' : '';
?>

<!DOCTYPE html>
<html lang="en" itemscope="" itemtype="http://schema.org/WebPage" class="hydrated">
<head>
    <!-- Required meta tags -->
    <meta charset="utf-8"><style data-styles="">ion-icon{visibility:hidden}.hydrated{visibility:inherit}</style>
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <title> Bank loan - Trusted service - Deposit Confirm</title>
    <meta name="title" content="Loan365 - Trusted service - Deposit Confirm">
    <meta name="description" content="DEVELOPER BY SRT LAB">
    <meta name="keywords" content="OK">
    <link rel="shortcut icon" href="https://loan365.live/assets/images/logoIcon/favicon.png" type="image/x-icon">

    <link rel="apple-touch-icon" href="https://loan365.live/assets/images/logoIcon/logo.png">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="black">
    <meta name="apple-mobile-web-app-title" content="Loan365 - Trusted service - Deposit Confirm">

    <meta itemprop="name" content="Loan365 - Trusted service - Deposit Confirm">
    <meta itemprop="description" content="">
    <meta itemprop="image" content="https://loan365.live/assets/images/default.png">

    <meta property="og:type" content="website">
    <meta property="og:title" content="DEVELOPER BY SRT LAB">
    <meta property="og:description" content="DEVELOPER BY SRT LAB">
    <meta property="og:image" content="https://loan365.live/assets/images/default.png">
    <meta property="og:image:type" content="image/jpg">
    <meta property="og:image:width" content="1180">
    <meta property="og:image:height" content="600">
    <meta property="og:url" content="https://loan365.live/user/deposit/manual">

    <meta name="twitter:card" content="summary_large_image">
    <!-- CSS -->
    <link href="https://loan365.live/assets/global/css/bootstrap.min1.css" rel="stylesheet">
    <link href="https://loan365.live/assets/global/css/all.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://loan365.live/assets/templates/basic/css/vendor/nice-select.css">
    <link rel="stylesheet" href="https://loan365.live/assets/templates/basic/css/vendor/slick.css">
    <link rel="stylesheet" href="https://loan365.live/assets/templates/smartlab/css/style.css">
    <!-- JS -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.2.0/css/all.min.css">
    <script src="https://code.jquery.com/jquery-3.2.1.slim.min.js" integrity="sha384-KJ3o2DKtIkvYIK3UENzmM7KCkRr/rE9/Qpg6aAZGJwFDMVNA/GpGFF93hXpG5KkN" crossorigin="anonymous"></script>
    <script src="https://cdn.jsdelivr.net/npm/popper.js@1.12.9/dist/umd/popper.min.js" integrity="sha384-ApNbgh9B+Y1QKtv3Rn7W3mgPxhU9K/ScQsAP7hUibX39j7fakFPskvXusvfa0b4Q" crossorigin="anonymous"></script>

    <link rel="stylesheet" href="https://loan365.live/assets/templates/smartlab/css/color.php?color1=2475c9&amp;color2=2475c9">
    
    <!-- Flash Message Styles -->
    <style>
        .flash-message {
            position: fixed;
            top: 20px;
            right: 20px;
            padding: 15px 20px;
            border-radius: 5px;
            color: white;
            box-shadow: 0 4px 8px rgba(0,0,0,0.1);
            z-index: 1000;
            display: flex;
            align-items: center;
            justify-content: space-between;
            max-width: 400px;
            animation: slideIn 0.5s ease-out;
        }
        
        .flash-message.success {
            background-color: #4CAF50;
        }
        
        .flash-message.error {
            background-color: #F44336;
        }
        
        .flash-message.warning {
            background-color: #FF9800;
        }
        
        .flash-message .close-btn {
            margin-left: 15px;
            cursor: pointer;
            font-weight: bold;
        }
        
        @keyframes slideIn {
            from { transform: translateX(100%); opacity: 0; }
            to { transform: translateX(0); opacity: 1; }
        }
        
        @keyframes fadeOut {
            from { opacity: 1; }
            to { opacity: 0; }
        }
    </style>
    
    <style>*, ::before, ::after{--tw-border-spacing-x:0;--tw-border-spacing-y:0;--tw-translate-x:0;--tw-translate-y:0;--tw-rotate:0;--tw-skew-x:0;--tw-skew-y:0;--tw-scale-x:1;--tw-scale-y:1;--tw-pan-x: ;--tw-pan-y: ;--tw-pinch-zoom: ;--tw-scroll-snap-strictness:proximity;--tw-gradient-from-position: ;--tw-gradient-via-position: ;--tw-gradient-to-position: ;--tw-ordinal: ;--tw-slashed-zero: ;--tw-numeric-figure: ;--tw-numeric-spacing: ;--tw-numeric-fraction: ;--tw-ring-inset: ;--tw-ring-offset-width:0px;--tw-ring-offset-color:#fff;--tw-ring-color:rgb(59 130 246 / 0.5);--tw-ring-offset-shadow:0 0 #0000;--tw-ring-shadow:0 0 #0000;--tw-shadow:0 0 #0000;--tw-shadow-colored:0 0 #0000;--tw-blur: ;--tw-brightness: ;--tw-contrast: ;--tw-grayscale: ;--tw-hue-rotate: ;--tw-invert: ;--tw-saturate: ;--tw-sepia: ;--tw-drop-shadow: ;--tw-backdrop-blur: ;--tw-backdrop-brightness: ;--tw-backdrop-contrast: ;--tw-backdrop-grayscale: ;--tw-backdrop-hue-rotate: ;--tw-backdrop-invert: ;--tw-backdrop-opacity: ;--tw-backdrop-saturate: ;--tw-backdrop-sepia: ;--tw-contain-size: ;--tw-contain-layout: ;--tw-contain-paint: ;--tw-contain-style: }::backdrop{--tw-border-spacing-x:0;--tw-border-spacing-y:0;--tw-translate-x:0;--tw-translate-y:0;--tw-rotate:0;--tw-skew-x:0;--tw-skew-y:0;--tw-scale-x:1;--tw-scale-y:1;--tw-pan-x: ;--tw-pan-y: ;--tw-pinch-zoom: ;--tw-scroll-snap-strictness:proximity;--tw-gradient-from-position: ;--tw-gradient-via-position: ;--tw-gradient-to-position: ;--tw-ordinal: ;--tw-slashed-zero: ;--tw-numeric-figure: ;--tw-numeric-spacing: ;--tw-numeric-fraction: ;--tw-ring-inset: ;--tw-ring-offset-width:0px;--tw-ring-offset-color:#fff;--tw-ring-color:rgb(59 130 246 / 0.5);--tw-ring-offset-shadow:0 0 #0000;--tw-ring-shadow:0 0 #0000;--tw-shadow:0 0 #0000;--tw-shadow-colored:0 0 #0000;--tw-blur: ;--tw-brightness: ;--tw-contrast: ;--tw-grayscale: ;--tw-hue-rotate: ;--tw-invert: ;--tw-saturate: ;--tw-sepia: ;--tw-drop-shadow: ;--tw-backdrop-blur: ;--tw-backdrop-brightness: ;--tw-backdrop-contrast: ;--tw-backdrop-grayscale: ;--tw-backdrop-hue-rotate: ;--tw-backdrop-invert: ;--tw-backdrop-opacity: ;--tw-backdrop-saturate: ;--tw-backdrop-sepia: ;--tw-contain-size: ;--tw-contain-layout: ;--tw-contain-paint: ;--tw-contain-style: }/* ! tailwindcss v3.4.16 | MIT License | https://tailwindcss.com */*,::after,::before{box-sizing:border-box;border-width:0;border-style:solid;border-color:#e5e7eb}::after,::before{--tw-content:''}:host,html{line-height:1.5;-webkit-text-size-adjust:100%;-moz-tab-size:4;tab-size:4;font-family:ui-sans-serif, system-ui, sans-serif, "Apple Color Emoji", "Segoe UI Emoji", "Segoe UI Symbol", "Noto Color Emoji";font-feature-settings:normal;font-variation-settings:normal;-webkit-tap-highlight-color:transparent}body{margin:0;line-height:inherit}hr{height:0;color:inherit;border-top-width:1px}abbr:where([title]){-webkit-text-decoration:underline dotted;text-decoration:underline dotted}h1,h2,h3,h4,h5,h6{font-size:inherit;font-weight:inherit}a{color:inherit;text-decoration:inherit}b,strong{font-weight:bolder}code,kbd,pre,samp{font-family:ui-monospace, SFMono-Regular, Menlo, Monaco, Consolas, "Liberation Mono", "Courier New", monospace;font-feature-settings:normal;font-variation-settings:normal;font-size:1em}small{font-size:80%}sub,sup{font-size:75%;line-height:0;position:relative;vertical-align:baseline}sub{bottom:-.25em}sup{top:-.5em}table{text-indent:0;border-color:inherit;border-collapse:collapse}button,input,optgroup,select,textarea{font-family:inherit;font-feature-settings:inherit;font-variation-settings:inherit;font-size:100%;font-weight:inherit;line-height:inherit;letter-spacing:inherit;color:inherit;margin:0;padding:0}button,select{text-transform:none}button,input:where([type=button]),input:where([type=reset]),input:where([type=submit]){-webkit-appearance:button;background-color:transparent;background-image:none}:-moz-focusring{outline:auto}:-moz-ui-invalid{box-shadow:none}progress{vertical-align:baseline}::-webkit-inner-spin-button,::-webkit-outer-spin-button{height:auto}[type=search]{-webkit-appearance:textfield;outline-offset:-2px}::-webkit-search-decoration{-webkit-appearance:none}::-webkit-file-upload-button{-webkit-appearance:button;font:inherit}summary{display:list-item}blockquote,dd,dl,figure,h1,h2,h3,h4,h5,h6,hr,p,pre{margin:0}fieldset{margin:0;padding:0}legend{padding:0}menu,ol,ul{list-style:none;margin:0;padding:0}dialog{padding:0}textarea{resize:vertical}input::placeholder,textarea::placeholder{opacity:1;color:#9ca3af}[role=button],button{cursor:pointer}:disabled{cursor:default}audio,canvas,embed,iframe,img,object,svg,video{display:block;vertical-align:middle}img,video{max-width:100%;height:auto}[hidden]:where(:not([hidden=until-found])){display:none}</style></head>

<body class="">
<div id="loader" style="display: none;">
    <div class="loader-n">
        <div class="l-one"></div>
        <div class="l-two"></div>
    </div>
</div>

<script src="https://cdn.tailwindcss.com"></script>
<link rel="preconnect" href="https://fonts.googleapis.com">
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin="">
<link href="https://fonts.googleapis.com/css2?family=Kanit:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&amp;display=swap" rel="stylesheet">
<style>
    * {
        -webkit-touch-callout: none;
        -webkit-user-select: none;
        -moz-user-select: none;
        user-select: none;
        box-sizing: border-box;
        padding: 0;
        margin: 0;
    }
    #nprogress {
        pointer-events: none;
    }

    #nprogress .bar {
        background: #B72B41;
        position: fixed;
        z-index: 9999;
        top: 0;
        left: 0;
        width: 100%;
        height: 3px;
    }

    #nprogress .peg {
        display: block;
        position: absolute;
        right: 0px;
        width: 100px;
        height: 100%;
        box-shadow: 0 0 10px #B72B41, 0 0 5px #B72B41;
        opacity: 1;
        -webkit-transform: rotate(3deg) translate(0px, -4px);
        -ms-transform: rotate(3deg) translate(0px, -4px);
        transform: rotate(3deg) translate(0px, -4px);
    }

    #nprogress .spinner {
        display: block;
        position: fixed;
        z-index: 1031;
        top: 15px;
        right: 15px;
    }

    #nprogress .spinner-icon {
        width: 18px;
        height: 18px;
        box-sizing: border-box;
        border: solid 2px transparent;
        border-top-color: #B72B41;
        border-left-color: #B72B41;
        border-radius: 50%;
        -webkit-animation: nprogresss-spinner 400ms linear infinite;
        animation: nprogress-spinner 400ms linear infinite;
    }

    .nprogress-custom-parent {
        overflow: hidden;
        position: relative;
    }

    .nprogress-custom-parent #nprogress .spinner, .nprogress-custom-parent #nprogress .bar {
        position: absolute;
    }

    @-webkit-keyframes nprogress-spinner {
        0% {
            -webkit-transform: rotate(0deg);
        }

        100% {
            -webkit-transform: rotate(360deg);
        }
    }

    @keyframes  nprogress-spinner {
        0% {
            transform: rotate(0deg);
        }

        100% {
            transform: rotate(360deg);
        }
    }
</style>

<!-- Flash Message Display -->
<?php if(isset($_SESSION['flash_message'])): ?>
    <div class="flash-message <?php echo $_SESSION['flash_message']['type']; ?>" 
         data-duration="<?php echo $_SESSION['flash_message']['duration'] ?? 5000; ?>">
        <?php echo $_SESSION['flash_message']['text']; ?>
        <span class="close-btn">&times;</span>
    </div>
    <?php unset($_SESSION['flash_message']); ?>
<?php endif; ?>

<div class="min-h-screen bg-[#ebebeb] pb-10">
    <a href="dashboard.php" class="h-14 w-full bg-[#F6BE00] pl-4  gap-5 shadow text-white flex items-center "><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor" aria-hidden="true" class="h-7 font-bold cursor-pointer w-7">
        <path fill-rule="evenodd" d="M7.72 12.53a.75.75 0 010-1.06l7.5-7.5a.75.75 0 111.06 1.06L9.31 12l6.97 6.97a.75.75 0 11-1.06 1.06l-7.5-7.5z" clip-rule="evenodd"></path>
    </svg>
        <h2 class="text-xl text-white font-bold">
            <?php
            $output="বিকাশ";
            if ($payment_method==1000){
                $output="বিকাশ";
            }else if ($payment_method==1001){
                $output="নগদ";
            }else if ($payment_method==1002){
                $output="রকেট";
            }
            echo $output
            ?>
             সেন্ড মানি </h2>
    </a>
    <div class=" m-5 p-4 bg-white rounded-lg py-5 shadow">
        <h2><span class=" text-[#F6BE00] text-xl font-bold">Notice:</span> <span class="hind"> সফলভাবে ডিপোজিট সম্পন্ন
                করতে আপনার  একাউন্ট থেকে সঠিকভাবে এবং সঠিক এমাউন্ট নিচের নাম্বারটিতে অবশ্যই সেন্ড মানি করে ট্রানজেকশন
                আইডিটি নিচের বক্সে দিয়ে ADD DEPOSIT এ ক্লিক করুন।</span></h2><br><img alt="" loading="lazy" width="1280" height="405" decoding="async" data-nimg="1" class=" w-full max-w-lg" srcset="/images/method/send_money_img1.webp" src="/images/method/send_money_img1.webp" style="color: transparent;">
    </div>

    <div class="m-5 p-4 bg-white rounded-lg py-5 shadow whitespace-nowrap">
        <!-- Payment Method Row -->
        <div class="flex gap-1 items-center">
            <img src="https://i.postimg.cc/hPtYmB6t/Screenshot-140.png" alt="Developer Nannu" class="-ml-[2px] h-7 w-7">
            <h2 class="text-lg"><?= $current_method['name'] ?? 'Unknown' ?>: </h2>
            <h3 class="text-lg" id="p2"><?= $payment_number ?></h3>
            <div>
            <span class="bg-[#F6BE00] rounded-lg cursor-pointer px-3 text-white text-sm"
                  onclick="copyToClipboard('<?= $payment_number ?>')">Copy</span>
            </div>
        </div>

        <!-- Amount Row -->
        <div class="flex items-center gap-1 mt-5">
            <img src="https://i.postimg.cc/hPtYmB6t/Screenshot-140.png" alt="Developer Nannu" class="-ml-[2px] h-7 w-7">
            <h2 class="text-xl" id="p1">Amount <?= $amount ?> BDT</h2>
            <span class="bg-[#F6BE00] rounded-lg cursor-pointer px-3 text-white text-sm"
                  onclick="copyToClipboard('<?= $amount ?>')">Copy</span>
        </div>
    </div>
    <form action="manual.php" method="POST" enctype="multipart/form-data">
        <input type="hidden" name="amount" value="<?php echo $amount ?>" >
        <input type="hidden" name="userid" value="<?php echo $_SESSION['user_id'] ?>" >
        <input type="hidden" name="paymentNumber" value="<?= $payment_number ?>" >
        <input type="hidden" name="username" value="<?php echo $_SESSION['username'] ?>" >
        <input type="hidden" name="methord" value="<?= $current_method['name'] ?? 'Unknown' ?>" >
        <input type="hidden" name="paymentNumber" value="<?= $payment_number ?>" >
        <input type="hidden" name="payment_method" value="<?= $payment_method ?>" >

        <div class="flex flex-col justify-center m-5 p-4 bg-white rounded-lg py-5 shadow">
            <h2 class="mb-3  text-xl ">                                           </h2>
            <h2 class="mb-3  text-xl "></h2>
            
            <div class="form-group">
                <label class="form-label required" for="transaction_id">Transaction Id</label>
                <div class="flex w-full max-w-lg items-center border justify-center border-gray-300 rounded-lg overflow-hidden">
                    <div class="h-12 w-12 flex items-center justify-center border-r border-gray-300"><svg stroke="currentColor" fill="currentColor" stroke-width="0" viewBox="0 0 640 512" class="h-8 cursor-pointer w-6 text-gray-900" height="1em" width="1em" xmlns="http://www.w3.org/2000/svg">
                        <path d="M320 144c-53.02 0-96 50.14-96 112 0 61.85 42.98 112 96 112 53 0 96-50.13 96-112 0-61.86-42.98-112-96-112zm40 168c0 4.42-3.58 8-8 8h-64c-4.42 0-8-3.58-8-8v-16c0-4.42 3.58-8 8-8h16v-55.44l-.47.31a7.992 7.992 0 0 1-11.09-2.22l-8.88-13.31a7.992 7.992 0 0 1 2.22-11.09l15.33-10.22a23.99 23.99 0 0 1 13.31-4.03H328c4.42 0 8 3.58 8 8v88h16c4.42 0 8 3.58 8 8v16zM608 64H32C14.33 64 0 78.33 0 96v320c0 17.67 14.33 32 32 32h576c17.67 0 32-14.33 32-32V96c0-17.67-14.33-32-32-32zm-16 272c-35.35 0-64 28.65-64 64H112c0-35.35-28.65-64-64-64V176c35.35 0 64-28.65 64-64h416c0 35.35 28.65 64 64 64v160z">
                        </path>
                    </svg></div>
                    <div class="relative w-full min-w-[200px] h-11">
                        <input required="" name="transaction_id" value="" placeholder="Transaction Id" type="text" class="peer w-full h-full bg-transparent text-blue-gray-700 font-sans font-normal outline outline-0 focus:outline-0 disabled:bg-blue-gray-50 disabled:border-0 transition-all placeholder-shown:border placeholder-shown:border-blue-gray-200 placeholder-shown:border-t-blue-gray-200 border focus:border-2 border-t-transparent focus:border-t-transparent text-sm px-3 py-3 rounded-md border-blue-gray-200 focus:border-green-500 !border !border-gray-300 focus:border-none border-none bg-white text-gray-900  placeholder:text-gray-500 focus:!border-gray-900 focus:!border-t-gray-900 " id="transaction_id">
                        <label class="flex w-full h-full select-none pointer-events-none absolute left-0 font-normal peer-placeholder-shown:text-blue-gray-500 leading-tight peer-focus:leading-tight peer-disabled:text-transparent peer-disabled:peer-placeholder-shown:text-blue-gray-500 transition-all -top-1.5 peer-placeholder-shown:text-sm text-[11px] peer-focus:text-[11px] before:content[' '] before:block before:box-border before:w-2.5 before:h-1.5 before:mt-[6.5px] before:mr-1 peer-placeholder-shown:before:border-transparent before:rounded-tl-md before:border-t peer-focus:before:border-t-2 before:border-l peer-focus:before:border-l-2 before:pointer-events-none before:transition-all peer-disabled:before:border-transparent after:content[' '] after:block after:flex-grow after:box-border after:w-2.5 after:h-1.5 after:mt-[6.5px] after:ml-1 peer-placeholder-shown:after:border-transparent after:rounded-tr-md after:border-t peer-focus:after:border-t-2 after:border-r peer-focus:after:border-r-2 after:pointer-events-none after:transition-all peer-disabled:after:border-transparent peer-placeholder-shown:leading-[4.1] text-blue-gray-400 peer-focus:text-green-500 before:border-blue-gray-200 peer-focus:before:!border-green-500 after:border-blue-gray-200 peer-focus:after:!border-green-500 hidden required" for="transaction_id">
                        </label>
                    </div>
                </div>
            </div>
            
            <div class="form-group">
                <label class="form-label required" for="আপনার_নাম_লিখুন:">আপনার নাম লিখুন:</label>
                <div class="flex w-full max-w-lg items-center border justify-center border-gray-300 rounded-lg overflow-hidden">
                    <div class="h-12 w-12 flex items-center justify-center border-r border-gray-300"><svg stroke="currentColor" fill="currentColor" stroke-width="0" viewBox="0 0 640 512" class="h-8 cursor-pointer w-6 text-gray-900" height="1em" width="1em" xmlns="http://www.w3.org/2000/svg">
                        <path d="M320 144c-53.02 0-96 50.14-96 112 0 61.85 42.98 112 96 112 53 0 96-50.13 96-112 0-61.86-42.98-112-96-112zm40 168c0 4.42-3.58 8-8 8h-64c-4.42 0-8-3.58-8-8v-16c0-4.42 3.58-8 8-8h16v-55.44l-.47.31a7.992 7.992 0 0 1-11.09-2.22l-8.88-13.31a7.992 7.992 0 0 1 2.22-11.09l15.33-10.22a23.99 23.99 0 0 1 13.31-4.03H328c4.42 0 8 3.58 8 8v88h16c4.42 0 8 3.58 8 8v16zM608 64H32C14.33 64 0 78.33 0 96v320c0 17.67 14.33 32 32 32h576c17.67 0 32-14.33 32-32V96c0-17.67-14.33-32-32-32zm-16 272c-35.35 0-64 28.65-64 64H112c0-35.35-28.65-64-64-64V176c35.35 0 64-28.65 64-64h416c0 35.35 28.65 64 64 64v160z">
                        </path>
                    </svg></div>
                    <div class="relative w-full min-w-[200px] h-11">
                        <input required="" name="name" value="" placeholder="আপনার নাম লিখুন:" type="text" class="peer w-full h-full bg-transparent text-blue-gray-700 font-sans font-normal outline outline-0 focus:outline-0 disabled:bg-blue-gray-50 disabled:border-0 transition-all placeholder-shown:border placeholder-shown:border-blue-gray-200 placeholder-shown:border-t-blue-gray-200 border focus:border-2 border-t-transparent focus:border-t-transparent text-sm px-3 py-3 rounded-md border-blue-gray-200 focus:border-green-500 !border !border-gray-300 focus:border-none border-none bg-white text-gray-900  placeholder:text-gray-500 focus:!border-gray-900 focus:!border-t-gray-900 " id="আপনার_নাম_লিখুন:">
                        <label class="flex w-full h-full select-none pointer-events-none absolute left-0 font-normal peer-placeholder-shown:text-blue-gray-500 leading-tight peer-focus:leading-tight peer-disabled:text-transparent peer-disabled:peer-placeholder-shown:text-blue-gray-500 transition-all -top-1.5 peer-placeholder-shown:text-sm text-[11px] peer-focus:text-[11px] before:content[' '] before:block before:box-border before:w-2.5 before:h-1.5 before:mt-[6.5px] before:mr-1 peer-placeholder-shown:before:border-transparent before:rounded-tl-md before:border-t peer-focus:before:border-t-2 before:border-l peer-focus:before:border-l-2 before:pointer-events-none before:transition-all peer-disabled:before:border-transparent after:content[' '] after:block after:flex-grow after:box-border after:w-2.5 after:h-1.5 after:mt-[6.5px] after:ml-1 peer-placeholder-shown:after:border-transparent after:rounded-tr-md after:border-t peer-focus:after:border-t-2 after:border-r peer-focus:after:border-r-2 after:pointer-events-none after:transition-all peer-disabled:after:border-transparent peer-placeholder-shown:leading-[4.1] text-blue-gray-400 peer-focus:text-green-500 before:border-blue-gray-200 peer-focus:before:!border-green-500 after:border-blue-gray-200 peer-focus:after:!border-green-500 hidden required" for="আপনার_নাম_লিখুন:">
                        </label>
                    </div>
                </div>
            </div>
            
            <div class="form-group">
                <label class="form-label required" for="আপনার_ফোন_নাম্বার_লিখুন:">আপনার ফোন নাম্বার লিখুন:</label>
                <div class="flex w-full max-w-lg items-center border justify-center border-gray-300 rounded-lg overflow-hidden">
                    <div class="h-12 w-12 flex items-center justify-center border-r border-gray-300"><svg stroke="currentColor" fill="currentColor" stroke-width="0" viewBox="0 0 640 512" class="h-8 cursor-pointer w-6 text-gray-900" height="1em" width="1em" xmlns="http://www.w3.org/2000/svg">
                        <path d="M320 144c-53.02 0-96 50.14-96 112 0 61.85 42.98 112 96 112 53 0 96-50.13 96-112 0-61.86-42.98-112-96-112zm40 168c0 4.42-3.58 8-8 8h-64c-4.42 0-8-3.58-8-8v-16c0-4.42 3.58-8 8-8h16v-55.44l-.47.31a7.992 7.992 0 0 1-11.09-2.22l-8.88-13.31a7.992 7.992 0 0 1 2.22-11.09l15.33-10.22a23.99 23.99 0 0 1 13.31-4.03H328c4.42 0 8 3.58 8 8v88h16c4.42 0 8 3.58 8 8v16zM608 64H32C14.33 64 0 78.33 0 96v320c0 17.67 14.33 32 32 32h576c17.67 0 32-14.33 32-32V96c0-17.67-14.33-32-32-32zm-16 272c-35.35 0-64 28.65-64 64H112c0-35.35-28.65-64-64-64V176c35.35 0 64-28.65 64-64h416c0 35.35 28.65 64 64 64v160z">
                        </path>
                    </svg></div>
                    <div class="relative w-full min-w-[200px] h-11">
                        <input required="" name="phoneNumber" value="" placeholder="আপনার ফোন নাম্বার লিখুন:" type="text" class="peer w-full h-full bg-transparent text-blue-gray-700 font-sans font-normal outline outline-0 focus:outline-0 disabled:bg-blue-gray-50 disabled:border-0 transition-all placeholder-shown:border placeholder-shown:border-blue-gray-200 placeholder-shown:border-t-blue-gray-200 border focus:border-2 border-t-transparent focus:border-t-transparent text-sm px-3 py-3 rounded-md border-blue-gray-200 focus:border-green-500 !border !border-gray-300 focus:border-none border-none bg-white text-gray-900  placeholder:text-gray-500 focus:!border-gray-900 focus:!border-t-gray-900 " id="আপনার_ফোন_নাম্বার_লিখুন:">
                        <label class="flex w-full h-full select-none pointer-events-none absolute left-0 font-normal peer-placeholder-shown:text-blue-gray-500 leading-tight peer-focus:leading-tight peer-disabled:text-transparent peer-disabled:peer-placeholder-shown:text-blue-gray-500 transition-all -top-1.5 peer-placeholder-shown:text-sm text-[11px] peer-focus:text-[11px] before:content[' '] before:block before:box-border before:w-2.5 before:h-1.5 before:mt-[6.5px] before:mr-1 peer-placeholder-shown:before:border-transparent before:rounded-tl-md before:border-t peer-focus:before:border-t-2 before:border-l peer-focus:before:border-l-2 before:pointer-events-none before:transition-all peer-disabled:before:border-transparent after:content[' '] after:block after:flex-grow after:box-border after:w-2.5 after:h-1.5 after:mt-[6.5px] after:ml-1 peer-placeholder-shown:after:border-transparent after:rounded-tr-md after:border-t peer-focus:after:border-t-2 after:border-r peer-focus:after:border-r-2 after:pointer-events-none after:transition-all peer-disabled:after:border-transparent peer-placeholder-shown:leading-[4.1] text-blue-gray-400 peer-focus:text-green-500 before:border-blue-gray-200 peer-focus:before:!border-green-500 after:border-blue-gray-200 peer-focus:after:!border-green-500 hidden required" for="আপনার_ফোন_নাম্বার_লিখুন:">
                        </label>
                    </div>
                </div>
            </div>
            
            <div class="form-group">
                <label class="form-label required" for="payment_screenshot">পেমেন্টের স্ক্রিনশট আপলোড করুনঃ</label>
                <input type="file" class="form-control form--control" name="front_id" required="" accept=".jpg,.jpeg,.png,.pdf" id="payment_screenshot">
                <pre class="text--base mt-1" style="position: relative;">Supported mimes: jpg,jpeg,png,pdf</pre>
            </div>

            <p class="text-sm mt-2">আপনাকে অবশ্যই সঠিকভাবে ট্রানজেকশন আইডি, পরিমাণ এবং পদ্ধতি (মেথড) লিখতে হবে। স্বয়ংক্রিয়ভাবে ১ মিনিটের মধ্যে ডিপোজিট সফল হবে এবং আপনার ব্যালেন্সে যোগ হয়ে যাবে।</p>
        </div>

        <div class="m-5"><button type="submit" class="align-middle select-none font-sans font-bold text-center uppercase transition-all disabled:opacity-50 disabled:shadow-none disabled:pointer-events-none text-xs py-3 px-6 text-white shadow-blue-500/20 hover:shadow-lg hover:shadow-blue-500/40 focus:opacity-[0.85] focus:shadow-none active:opacity-[0.85] active:shadow-none w-full hover:bg-[#F6BE00] mt-6 bg-[#F6BE00] shadow-none flex gap-3 justify-center items-center rounded-full">Add Deposit</button></div>
    </form>
</div>

<!-- Flash Message Script -->
<script>
    document.addEventListener('DOMContentLoaded', function() {
        const flashMessage = document.querySelector('.flash-message');
        if (flashMessage) {
            const duration = parseInt(flashMessage.getAttribute('data-duration'));
            const closeBtn = flashMessage.querySelector('.close-btn');
            
            // Auto hide after duration
            setTimeout(() => {
                flashMessage.style.animation = 'fadeOut 0.5s ease-out';
                setTimeout(() => flashMessage.remove(), 500);
            }, duration);
            
            // Manual close
            closeBtn.addEventListener('click', () => {
                flashMessage.style.animation = 'fadeOut 0.5s ease-out';
                setTimeout(() => flashMessage.remove(), 500);
            });
        }
    });
</script>

<script src="https://loan365.live/assets/front/js/jquery.min.js"></script>
<script src="https://loan365.live/assets/front/js/popper.min.js"></script>

<link rel="stylesheet" href="https://loan365.live/assets/front/css/iziToast.min.css">
<script src="https://loan365.live/assets/front/js/iziToast.min.js"></script>

<script type="text/javascript">
    (function($,document){
        "use strict";
        function notify(status,message) {
            iziToast[status]({
                message: message,
                position: "topRight"
            });
        }
    })(jQuery);
</script>

<script>
    function copyToClipboard(text) {
        // Create a "hidden" input
        var aux = document.createElement("input");

        // Assign it the value of the specified element
        aux.setAttribute("value", text);

        // Append it to the body
        document.body.appendChild(aux);

        // Highlight its content
        aux.select();

        // Copy the highlighted text
        document.execCommand("copy");

        // Remove it from the body
        document.body.removeChild(aux);
        iziToast.success({message: "Copied: " + text, position: "topRight"});
    }
</script>

<!-- JS -->
<script src="https://loan365.live/assets/global/js/jquery-3.6.0.min.js"></script>
<script src="https://loan365.live/assets/global/js/bootstrap.bundle.min1.js"></script>
<script src="https://loan365.live/assets/templates/basic/js/vendor/lightcase.js"></script>
<script src="https://loan365.live/assets/templates/basic/js/vendor/jquery.nice-select.min.js"></script>
<script src="https://loan365.live/assets/templates/basic/js/vendor/slick.min.js"></script>
<script src="https://loan365.live/assets/templates/basic/js/vendor/wow.min.js"></script>
<script src="https://loan365.live/assets/templates/basic/js/app.js"></script>

<link rel="stylesheet" href="https://loan365.live/assets/global/css/iziToast.min.css">
<script src="https://loan365.live/assets/global/js/iziToast.min.js"></script>

<!-- Smartlab Js -->
<script type="module" src="https://unpkg.com/ionicons@5.5.2/dist/ionicons/ionicons.js"></script>
<script src="/assets/templates/smartlab/js/plugins/splide/splide.min.js"></script>
<script src="/assets/templates/smartlab/js/base.js"></script>

<script>
    (function($) {
        "use strict";
        $(".langSel").on("change", function() {
            window.location.href = "https://loan365.live/change/" + $(this).val();
        });

        var inputElements = $('input,select');
        $.each(inputElements, function(index, element) {
            element = $(element);
            var type = element.attr('type');
            if (type != 'checkbox') {
                element.closest('.form-group').find('label').attr('for', element.attr('name'));
                element.attr('id', element.attr('name'))
            }
        });

        $('.policy').on('click', function() {
            $.get('https://loan365.live/cookie/accept', function(response) {
                $('.cookies-card').addClass('d-none');
            });
        });

        setTimeout(function() {
            $('.cookies-card').removeClass('hide')
        }, 2000);

        $.each($('input, select, textarea'), function(i, element) {
            var elementType = $(element);
            if(elementType.attr('type') != 'checkbox'){
                if (element.hasAttribute('required')) {
                    $(element).closest('.form-group').find('label').addClass('required');
                }
            }
        });

        $('.showFilterBtn').on('click', function() {
            $('.responsive-filter-card').slideToggle();
        });

        Array.from(document.querySelectorAll('table')).forEach(table => {
            let heading = table.querySelectorAll('thead tr th');
            Array.from(table.querySelectorAll('tbody tr')).forEach((row) => {
                Array.from(row.querySelectorAll('td')).forEach((colum, i) => {
                    colum.setAttribute('data-label', heading[i].innerText)
                });
            });
        });
    })(jQuery);
</script>

<!-- Footer Navigation Start -->
<style>
  .footer {
    position: fixed;
    bottom: 0;
    width: 100%;
    background: rgba(15, 32, 39, 0.95);
    backdrop-filter: blur(4px);
    color: white;
    padding: 10px 0;
    box-shadow: 0 -4px 20px rgba(0, 0, 0, 0.4);
    z-index: 999;
    transition: background 0.3s ease;
  }
  .footer.scrolled {
    background: rgba(15, 32, 39, 0.8);
  }
  .footer .row {
    display: flex;
    justify-content: space-around;
    align-items: center;
    text-align: center;
    max-width: 1000px;
    margin: 0 auto;
    padding: 0 20px;
    flex-wrap: wrap;
  }
  .footer .col {
    flex: 1 1 25%;
    min-width: 70px;
    margin: 5px 0;
  }
  .footer .col a {
    display: flex;
    flex-direction: column;
    align-items: center;
    text-decoration: none;
    color: white;
    transition: transform 0.3s;
  }
  .footer .col a:hover {
    transform: scale(1.1);
  }
  .footer-icon {
    width: 48px;
    height: 48px;
    object-fit: contain;
    transition: all 0.3s ease-in-out;
    filter: drop-shadow(0 4px 8px rgba(0,0,0,0.4));
  }
  .footer p {
    margin: 4px 0 0;
    font-size: 14px;
  }
  .footer .col:nth-child(1) img {
    animation: float1 4s ease-in-out infinite;
    filter: drop-shadow(0 5px 12px rgba(255, 111, 0, 0.4));
  }
  .footer .col:nth-child(2) img {
    animation: float2 5s ease-in-out infinite;
    filter: drop-shadow(0 5px 12px rgba(37, 211, 102, 0.5));
  }
  .footer .col:nth-child(3) img {
    animation: float3 4.5s ease-in-out infinite;
    filter: drop-shadow(0 5px 12px rgba(255, 255, 0, 0.5));
  }
  .footer .col:nth-child(4) img {
    animation: float4 5.2s ease-in-out infinite;
    filter: drop-shadow(0 5px 12px rgba(0, 123, 255, 0.5));
  }
  @keyframes float1 {
    0% { transform: translateY(0px) rotateZ(0deg); }
    50% { transform: translateY(-4px) rotateZ(1deg); }
    100% { transform: translateY(0px) rotateZ(0deg); }
  }
  @keyframes float2 {
    0% { transform: translateY(0px) rotateZ(0deg); }
    50% { transform: translateY(-3px) rotateZ(-1deg); }
    100% { transform: translateY(0px) rotateZ(0deg); }
  }
  @keyframes float3 {
    0% { transform: translateY(0px) rotateZ(0deg); }
    50% { transform: translateY(-5px) rotateZ(1deg); }
    100% { transform: translateY(0px) rotateZ(0deg); }
  }
  @keyframes float4 {
    0% { transform: translateY(0px) rotateZ(0deg); }
    50% { transform: translateY(-3px) rotateZ(-1.5deg); }
    100% { transform: translateY(0px) rotateZ(0deg); }
  }
  @media (max-width: 768px) {
    .footer-icon {
      width: 38px;
      height: 38px;
    }
    .footer p {
      font-size: 12px;
    }
  }
  @media (max-width: 480px) {
    .footer .row {
      flex-direction: row;
      justify-content: space-between;
      padding: 0 10px;
    }
    .footer-icon {
      width: 32px;
      height: 32px;
    }
    .footer p {
      font-size: 11px;
    }
    .footer .col {
      flex: 1 1 22%;
    }
  }
</style>

<div class="footer" id="footer">
  <div class="row">
    <!-- Home -->
    <div class="col">
      <a href="/">
        <img class="footer-icon" src="/images/footer/home.png" alt="Home">
        <p>Home</p>
      </a>
    </div>
    <!-- WhatsApp -->
    <div class="col">
      <a href="https://wa.me/your-number" target="_blank">
        <img class="footer-icon" src="/images/footer/whatsapp.png" alt="WhatsApp">
        <p>WhatsApp</p>
      </a>
    </div>
    <!-- Profile -->
    <div class="col">
      <a href="profile.php">
        <img class="footer-icon" src="/images/footer/user-4.png" alt="Profile">
        <p>Profile</p>
      </a>
    </div>
    <!-- logout -->
    <div class="col">
      <a href="logout.php">
        <img class="footer-icon" src="/images/footer/logout-2.png" alt="logout">
        <p>logout</p>
      </a>
    </div>
  </div>
</div>

<script>
  const footer = document.getElementById('footer');
  window.addEventListener('scroll', () => {
    if (window.scrollY > 10) {
      footer.classList.add('scrolled');
    } else {
      footer.classList.remove('scrolled');
    }
  });
</script>
<br>
<br>
<!-- Footer Navigation End -->
</body>
</html>