<?php
// Start session only once at the very beginning
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Database connection
$host = "localhost";
$user = "loannowl_loan1";
$pass = "loannowl_loan1";
$dbname = "loannowl_loan1";

$conn = new mysqli($host, $user, $pass, $dbname);

if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

$conn->set_charset("utf8mb4");

// Create necessary tables if they don't exist
$createTables = [
    "CREATE TABLE IF NOT EXISTS `settings` (
        `id` int(11) NOT NULL AUTO_INCREMENT,
        `logo` varchar(255) DEFAULT 'images/logo/logo4.png',
        `site_name` varchar(100) DEFAULT NULL,
        `contact_email` varchar(100) DEFAULT NULL,
        PRIMARY KEY (`id`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4",
    
    "CREATE TABLE IF NOT EXISTS `testimonials` (
        `id` int(11) NOT NULL AUTO_INCREMENT,
        `name` varchar(100) NOT NULL,
        `message` text NOT NULL,
        `date` datetime DEFAULT current_timestamp(),
        PRIMARY KEY (`id`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4"
];

foreach ($createTables as $sql) {
    if (!$conn->query($sql)) {
        die("Error creating table: " . $conn->error);
    }
}

// Insert default data if tables are empty
$checkSettings = $conn->query("SELECT COUNT(*) as count FROM `settings`");
if ($checkSettings && $checkSettings->fetch_assoc()['count'] == 0) {
    $conn->query("INSERT INTO `settings` (`logo`, `site_name`, `contact_email`) 
                 VALUES ('images/logo/logo4.png', 'Easy Loan', 'contact@example.com')");
}

$checkTestimonials = $conn->query("SELECT COUNT(*) as count FROM `testimonials`");
if ($checkTestimonials && $checkTestimonials->fetch_assoc()['count'] == 0) {
    $testimonialsData = [
        "INSERT INTO `testimonials` (`name`, `message`, `date`) VALUES 
        ('John Doe', 'Great service! Got my loan quickly.', '2023-01-15 10:30:00')",
        
        "INSERT INTO `testimonials` (`name`, `message`, `date`) VALUES 
        ('Jane Smith', 'Very helpful customer support.', '2023-02-20 11:45:00')",
        
        "INSERT INTO `testimonials` (`name`, `message`, `date`) VALUES 
        ('Robert Johnson', 'Simple process and fast approval.', '2023-03-10 09:15:00')"
    ];
    
    foreach ($testimonialsData as $sql) {
        $conn->query($sql);
    }
}

// Fetch WhatsApp number from database
$sql_whatsapp = "SELECT whatsapp FROM contact LIMIT 1";
$result_whatsapp = mysqli_query($conn, $sql_whatsapp);
$whatsapp_number = "";

if ($result_whatsapp && mysqli_num_rows($result_whatsapp) > 0) {
    $row = mysqli_fetch_assoc($result_whatsapp);
    $whatsapp_number = preg_replace('/[^0-9]/', '', $row['whatsapp']);
}

$get_videoInfo = "SELECT * FROM `contact` ORDER BY id DESC LIMIT 1";
$sql_video_query = mysqli_query($conn, $get_videoInfo);
$video_info = mysqli_fetch_assoc($sql_video_query);

function getYouTubeID($url) {
    parse_str(parse_url($url, PHP_URL_QUERY), $vars);
    return $vars['v'] ?? '';
}

$get_contacktInfo = "SELECT * FROM `contact` ORDER BY id DESC LIMIT 1";
$sql_query = mysqli_query($conn, $get_contacktInfo);
$contact_info = mysqli_fetch_assoc($sql_query);

// Fetch logo from settings table
$sql_logo = "SELECT logo FROM settings LIMIT 1";
$result_logo = mysqli_query($conn, $sql_logo);
$logo_url = "images/logo/logo4.png";

if ($result_logo && mysqli_num_rows($result_logo) > 0) {
    $row_logo = mysqli_fetch_assoc($result_logo);
    $logo_url = $row_logo['logo'];
}

if(isset($_SESSION["logged_in"]) && $_SESSION["logged_in"] == true) {
    header("location: dashboard.php");
    exit();
}

// Fetch all loan names
$sql_loan_name = "SELECT * FROM `loanname` ORDER BY `id` ASC";
$result_loan_name = mysqli_query($conn, $sql_loan_name);
$loan_names = mysqli_fetch_all($result_loan_name, MYSQLI_ASSOC);

// Fetch all product loans
$sql_product_loan = "SELECT * FROM `productloan` ORDER BY `loanTime` ASC";
$result_product_loan = mysqli_query($conn, $sql_product_loan);
$product_loans = mysqli_fetch_all($result_product_loan, MYSQLI_ASSOC);

// Get first loan for default display
$first_loan = $product_loans[0] ?? [];

// Process form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['loan_id'])) {
    $loan_id = mysqli_real_escape_string($conn, $_POST['loan_id']);
    $duration = isset($_POST['duration']) ? (int)$_POST['duration'] : 0;

    // Find the selected loan product
    $selected_loan = null;
    foreach ($product_loans as $loan) {
        if ($loan['loanId'] == $loan_id && $loan['loanTime'] == $duration) {
            $selected_loan = $loan;
            break;
        }
    }

    if ($selected_loan) {
        // Check if user has enough balance
        if (isset($_SESSION['Balancer']) && $_SESSION['Balancer'] >= $selected_loan['advance']) {
            // Process the loan application
            $user_id = $_SESSION['user_id'];
            $insert_sql = "INSERT INTO loan_applications 
                          (user_id, loan_id, amount, duration, advance, status) 
                          VALUES 
                          ('$user_id', '$loan_id', '{$selected_loan['loanAmount']}', '$duration', '{$selected_loan['advance']}', 'pending')";

            if (mysqli_query($conn, $insert_sql)) {
                $_SESSION['message'] = ['type' => 'success', 'text' => 'Loan application submitted successfully!'];
            } else {
                $_SESSION['message'] = ['type' => 'error', 'text' => 'Error submitting loan application'];
            }
        } else {
            $_SESSION['message'] = ['type' => 'error', 'text' => 'Insufficient balance for this loan'];
        }
    } else {
        $_SESSION['message'] = ['type' => 'error', 'text' => 'Invalid loan selection'];
    }

    header("Location: ".$_SERVER['PHP_SELF']);
    exit();
}

// Fetch testimonials
$sql_testimonials = "SELECT * FROM testimonials ORDER BY id DESC LIMIT 3";
$result_testimonials = mysqli_query($conn, $sql_testimonials);
$testimonials = mysqli_fetch_all($result_testimonials, MYSQLI_ASSOC);

// Generate CSRF token if not exists
if (empty($_SESSION['csrf_token'])) {
    $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>মাত্র ১০ মিনিটে অনলাইন থেকে লোন নিন</title>
    <meta name="description" content="মাত্র ১০ মিনিটে ঘরে বসেই অনলাইন লোন নিন — নিরাপদ, দ্রুত ও ঝামেলামুক্ত প্রক্রিয়ায়। ৫,০০০ থেকে ৫০,০০০ টাকা পর্যন্ত লোন, ন্যূনতম ডকুমেন্টে।">
    <link rel="shortcut icon" href="images/logo/favicon.ico" type="image/x-icon">
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" rel="stylesheet">
    <!-- Boxicons -->
    <link href="https://cdn.jsdelivr.net/npm/boxicons@2.1.4/css/boxicons.min.css" rel="stylesheet">
    
    <style>
        :root {
            --primary-color: #04460c;
            --secondary-color: #10704b;
            --dark-color: #044315;
            --light-color: #f8f9fa;
            --theme-bg: linear-gradient(135deg, var(--secondary-color), var(--primary-color));
            --theme-text: #ffffff;
            --theme-font-text: #333333;
            --card-shadow: 0 10px 30px rgba(0,0,0,0.08);
        }
        
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background-color: #f3f3ed;
            color: var(--theme-font-text);
        }
        
        /* Premium Header Styles */
        .app-header {
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            z-index: 1000;
            background: var(--theme-bg);
            padding: 15px 20px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            box-shadow: 0 4px 20px rgba(0,0,0,0.1);
        }
        
        .app-header .logo-container {
            display: flex;
            align-items: center;
        }
        
        .app-header .logo-container img {
            height: 48px;
            object-fit: contain;
        }
        
        .app-header .auth-buttons {
            display: flex;
            gap: 15px;
        }
        
        .app-header .auth-btn {
            padding: 10px 25px;
            font-size: 16px;
            font-weight: 600;
            background: rgba(255,255,255,0.2);
            color: white;
            border: 1px solid rgba(255,255,255,0.3);
            border-radius: 30px;
            transition: all 0.3s ease;
            text-decoration: none;
        }
        
        .app-header .auth-btn:hover {
            background: rgba(255,255,255,0.3);
            transform: translateY(-2px);
        }
        
        /* Main Content Container */
        .main-container {
            margin-top: 90px;
            margin-bottom: 30px;
            padding: 0 15px;
        }
        
        /* Announcement Bar with Marquee */
        .announcement-bar {
            background: rgba(255,255,255,0.9);
            border-radius: 10px;
            padding: 1px 15px;
            margin-bottom: 20px;
            box-shadow: var(--card-shadow);
            display: flex;
            align-items: center;
            overflow: hidden;
        }
        
        .announcement-icon {
            font-size: 20px;
            color: var(--primary-color);
            margin-right: 15px;
            flex-shrink: 0;
        }
        
        .announcement-text {
            flex: 1;
            font-size: 14px;
            font-weight: 500;
            white-space: nowrap;
            overflow: hidden;
        }
        
        .announcement-text marquee {
            display: inline-block;
            width: 100%;
        }
        
        /* Premium Popup Modal */
        .popup-modal {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0,0,0,0.8);
            z-index: 2000;
            align-items: center;
            justify-content: center;
            backdrop-filter: blur(5px);
        }
        
        .popup-content {
            background: white;
            border-radius: 15px;
            width: 90%;
            max-width: 500px;
            padding: 25px;
            text-align: center;
            position: relative;
            animation: popupFadeIn 0.4s cubic-bezier(0.175, 0.885, 0.32, 1.275);
            box-shadow: 0 15px 50px rgba(0,0,0,0.3);
            border: 1px solid rgba(255,255,255,0.2);
            overflow: hidden;
        }
        
        .popup-content::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 5px;
            background: linear-gradient(90deg, #25D366, #128C7E, #075E54);
        }
        
        .popup-close {
            position: absolute;
            top: 10px;
            right: 15px;
            font-size: 24px;
            color: #777;
            cursor: pointer;
            transition: all 0.3s ease;
            z-index: 1;
        }
        
        .popup-close:hover {
            color: #ff4757;
            transform: rotate(90deg);
        }
        
        .popup-image {
            width: 100%;
            max-height: 250px;
            object-fit: contain;
            border-radius: 10px;
            margin-bottom: 20px;
            border: 1px solid #eee;
            box-shadow: 0 5px 15px rgba(0,0,0,0.05);
        }
        
        .popup-title {
            font-size: 22px;
            font-weight: 700;
            color: #075E54;
            margin-bottom: 15px;
        }
        
        .popup-message {
            font-size: 16px;
            color: #555;
            margin-bottom: 25px;
            line-height: 1.6;
        }
        
        .popup-buttons {
            display: flex;
            gap: 15px;
            justify-content: center;
            flex-wrap: wrap;
        }
        
        .popup-btn {
            padding: 12px 25px;
            border-radius: 50px;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s ease;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 10px;
            text-decoration: none;
            min-width: 180px;
        }
        
        .whatsapp-btn {
            background: linear-gradient(135deg, #25D366, #128C7E);
            color: white;
            border: none;
        }
        
        .whatsapp-btn:hover {
            background: linear-gradient(135deg, #128C7E, #25D366);
            transform: translateY(-3px);
            box-shadow: 0 5px 15px rgba(37, 211, 102, 0.3);
        }
        
        .tutorial-btn {
            background: linear-gradient(135deg, #3498db, #2980b9);
            color: white;
            border: none;
        }
        
        .tutorial-btn:hover {
            background: linear-gradient(135deg, #2980b9, #3498db);
            transform: translateY(-3px);
            box-shadow: 0 5px 15px rgba(52, 152, 219, 0.3);
        }
        
        .countdown-timer {
            margin-top: 20px;
            font-size: 14px;
            color: #777;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 5px;
        }
        
        .countdown-circle {
            width: 30px;
            height: 30px;
            border-radius: 50%;
            background: #f1f1f1;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: 700;
            color: #075E54;
            border: 2px solid #ddd;
        }
        
        @keyframes popupFadeIn {
            from { opacity: 0; transform: translateY(20px) scale(0.95); }
            to { opacity: 1; transform: translateY(0) scale(1); }
        }
        
        /* Confirmation Modal */
        .confirmation-modal {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0,0,0,0.7);
            z-index: 2000;
            align-items: center;
            justify-content: center;
        }
        
        .confirmation-content {
            background: white;
            border-radius: 15px;
            width: 90%;
            max-width: 400px;
            padding: 25px;
            text-align: center;
            position: relative;
            animation: popupFadeIn 0.3s ease;
        }
        
        .confirmation-icon {
            font-size: 60px;
            color: var(--primary-color);
            margin-bottom: 20px;
        }
        
        .confirmation-title {
            font-size: 22px;
            font-weight: 700;
            margin-bottom: 15px;
            color: var(--secondary-color);
        }
        
        .confirmation-message {
            font-size: 16px;
            margin-bottom: 25px;
            line-height: 1.5;
        }
        
        .confirmation-btn {
            padding: 12px 30px;
            background: var(--primary-color);
            color: white;
            border: none;
            border-radius: 30px;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s ease;
        }
        
        .confirmation-btn:hover {
            background: var(--secondary-color);
            transform: translateY(-2px);
        }
        
        /* Loan Services Section */
        .loan-services-section {
            background: white;
            border-radius: 16px;
            box-shadow: var(--card-shadow);
            padding: 25px;
            margin-bottom: 25px;
            transition: all 0.3s ease;
        }
        
        .loan-services-section:hover {
            box-shadow: 0 15px 40px rgba(0,0,0,0.12);
        }
        
        .section-title {
            color: var(--secondary-color);
            font-size: 22px;
            font-weight: 700;
            margin-bottom: 15px;
            padding-bottom: 10px;
            border-bottom: 2px solid rgba(76, 200, 90, 0.2);
        }
        
         /* Loan Amount Display */
        .loan-amount-display {
            display: flex;
            background: var(--theme-bg);
            border-radius: 22px;
            padding: 1px;
            text-align: center;
            color: white;
            margin-bottom: 12px;
            position: relative;
            overflow: hidden;
            flex-direction: row;
            justify-content: space-evenly;
            align-content: space-between;
            flex-wrap: nowrap;
            align-items: baseline;
        }
        
        .loan-amount-display::before {
            content: "";
            position: absolute;
            top: -50%;
            left: -50%;
            width: 200%;
            height: 200%;
            background: radial-gradient(circle, rgba(255,255,255,0.1) 0%, rgba(255,255,255,0) 70%);
            transform: rotate(30deg);
        }
        
        .amount-label {
            font-size: 14px;
            opacity: 0.9;
            margin-bottom: 5px;
        }
        
        .amount-value {
            font-size: 36px;
            font-weight: 700;
            line-height: 1;
            margin: 10px 0;
        }
        
        .amount-currency {
            font-size: 16px;
            opacity: 0.9;
        }
        
        /* Loan Type Selection - 6 in a row */
        .loan-type-selection {
            margin-bottom: 15px;
        }
        
              .loan-type-title {
            display: flex;
            /* color: #000000b0; */
            font-size: 14px;
            /* margin-bottom: 15px; */
            font-weight: 600;
            justify-content: space-around;
            align-content: space-around;
        }
        
        .loan-type-options {
            display: flex;
            /* overflow-x: auto; */
            /* gap: 5px; */
            padding-bottom: 10px;
            scrollbar-width: none; /* Firefox */
            align-content: space-between;
            flex-direction: row;
            justify-content: space-between;
            align-items: center;
            flex-wrap: nowrap;
        }
        .loan-type-options::-webkit-scrollbar {
            display: none; /* Chrome/Safari */
        }
        
        .loan-type-option {
            flex: 3 2 calc(10.666% - 45px)
            background: #f8f9fa;
            border-radius: 10px;
            padding: 15px 5px;
            text-align: center;
            cursor: pointer;
            transition: all 0.3s ease;
            border: 1px solid #e0e0e0;
            min-width: 120px;
        }
        
        .loan-type-option:hover {
            transform: translateY(-3px);
            box-shadow: 0 5px 15px rgba(0,0,0,0.05);
        }
        
        .loan-type-option.active {
            background: var(--theme-bg);
            color: white;
            border-color: var(--primary-color);
        }
        
        .loan-type-option.active .loan-icon {
            color: white;
        }
        
        .loan-icon {
            font-size: 23px;
            color: var(--primary-color);
            margin-bottom: 8px;
        }
        
        .loan-name {
            font-size: 13px;
            font-weight: 500;
        }
        
        /* Amount Slider */
        .amount-slider-section {
            margin-bottom: 10px;
        }
        
           .amount-slider-title {
            display: flex;
            font-size: 14px;
            /* margin-bottom: 15px; */
            font-weight: 600;
            align-content: space-between;
            justify-content: space-around;
        }
        
        .loan-amount-slider {
            -webkit-appearance: none;
            width: 100%;
            height: 8px;
            border-radius: 5px;
            background: #e0e0e0;
            outline: none;
            margin: 15px 0;
        }
        
        .loan-amount-slider::-webkit-slider-thumb {
            -webkit-appearance: none;
            appearance: none;
            width: 24px;
            height: 24px;
            border-radius: 50%;
            background: var(--theme-bg);
            cursor: pointer;
            border: 3px solid white;
            box-shadow: 0 2px 10px rgba(0,0,0,0.2);
            transition: all 0.2s ease;
        }
        
        .loan-amount-slider::-webkit-slider-thumb:hover {
            transform: scale(1.1);
        }
        
        .slider-labels {
            display: flex;
            justify-content: space-between;
            font-size: 12px;
            color: #7f8c8d;
        }
        
        /* Duration Selection */
        .duration-selection {
            margin-bottom: 25px;
        }
        
          .duration-title {
            display: flex;
            color: var(--secondary-color);
            font-size: 16px;
            margin-bottom: 15px;
            font-weight: 600;
            align-content: space-between;
            justify-content: space-around;
        }
        
        .duration-options {
            display: flex;
            gap: 10px;
        }
        
        .duration-option {
            flex: 1;
            background: #f8f9fa;
            border-radius: 10px;
            padding: 15px 5px;
            text-align: center;
            cursor: pointer;
            transition: all 0.3s ease;
            border: 1px solid #e0e0e0;
        }
        
        .duration-option:hover {
            transform: translateY(-3px);
            box-shadow: 0 5px 15px rgba(0,0,0,0.05);
        }
        
        .duration-option.active {
            background: var(--theme-bg);
            color: white;
            border-color: var(--primary-color);
        }
        
        .duration-months {
            font-size: 20px;
            font-weight: 700;
            line-height: 1;
            margin-bottom: 5px;
        }
        
        .duration-label {
            font-size: 12px;
            opacity: 0.8;
        }
        
        /* Loan Details */
        .loan-details {
            background: #f8f9fa;
            border-radius: 12px;
            padding: 20px;
            margin: 25px 0;
            border: 1px solid #e0e0e0;
            display: none;
        }
        
        .detail-row {
            display: flex;
            justify-content: space-between;
            padding: 10px 0;
            border-bottom: 1px solid #e0e0e0;
        }
        
        .detail-row:last-child {
            border-bottom: none;
        }
        
        .detail-label {
            color: #7f8c8d;
            font-size: 14px;
        }
        
        .detail-value {
            color: var(--secondary-color);
            font-weight: 600;
        }
        
        /* Premium 3D Apply Button */
        .loan-submit-btn {
            width: 100%;
            padding: 16px;
            background: linear-gradient(135deg, #2ecc71, #27ae60);
            color: white;
            border: none;
            border-radius: 10px;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s ease;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 10px;
            position: relative;
            overflow: hidden;
            box-shadow: 0 5px 15px rgba(46, 204, 113, 0.4);
            text-transform: uppercase;
            letter-spacing: 1px;
        }
        
        .loan-submit-btn::before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255,255,255,0.2), transparent);
            transition: 0.5s;
        }
        
        .loan-submit-btn:hover {
            transform: translateY(-3px);
            box-shadow: 0 8px 25px rgba(46, 204, 113, 0.6);
        }
        
        .loan-submit-btn:hover::before {
            left: 100%;
        }
        
        .loan-submit-btn i {
            transition: transform 0.3s ease;
        }
        
        .loan-submit-btn:hover i {
            transform: translateX(5px);
        }
        
        /* Image Slider */
        .image-slider {
            border-radius: 16px;
            overflow: hidden;
            margin-bottom: 25px;
            box-shadow: var(--card-shadow);
        }
        
        .image-slider img {
            width: 100%;
            height: auto;
            display: block;
        }
        
        /* Quick Actions */
        .quick-actions {
            background: white;
            border-radius: 16px;
            box-shadow: var(--card-shadow);
            padding: 20px;
            margin-bottom: 25px;
        }
        
        .action-grid {
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            gap: 15px;
        }
        
        .action-item {
            text-align: center;
            padding: 15px 5px;
            border-radius: 10px;
            transition: all 0.3s ease;
        }
        
        .action-item:hover {
            background: #f8f9fa;
            transform: translateY(-3px);
        }
        
        .action-item a {
            text-decoration: none;
            color: var(--theme-font-text);
        }
        
        .action-icon {
            font-size: 24px;
            color: var(--primary-color);
            margin-bottom: 10px;
        }
        
        .action-label {
            font-size: 13px;
            font-weight: 500;
        }
        
        /* Video Section */
        .video-section {
            background: white;
            border-radius: 16px;
            box-shadow: var(--card-shadow);
            padding: 20px;
            margin-bottom: 25px;
        }
        
        .video-container {
            position: relative;
            width: 100%;
            border-radius: 12px;
            overflow: hidden;
            background: #f0f0f0;
            margin-top: 15px;
        }
        
        .video-container iframe {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            border: none;
        }
        
        /* Partners Section - 4 in a row */
        .partners-section {
            background: white;
            border-radius: 16px;
            box-shadow: var(--card-shadow);
            padding: 20px;
            margin-bottom: 25px;
        }
        
        .partner-grid {
            display: flex;
            flex-wrap: nowrap;
            overflow-x: auto;
            gap: 15px;
            padding-bottom: 10px;
            scrollbar-width: none; /* Firefox */
        }
        
        .partner-grid::-webkit-scrollbar {
            display: none; /* Chrome/Safari */
        }
        
        .partner-item {
            flex: 0 0 calc(25% - 12px);
            text-align: center;
            padding: 10px;
            min-width: 150px;
        }
        
        .partner-item img {
            max-height: 40px;
            width: auto;
            margin-bottom: 5px;
        }
        
        .partner-name {
            font-size: 12px;
            color: #7f8c8d;
        }
        
        /* Testimonials Section */
        .testimonials-section {
            background: white;
            border-radius: 16px;
            box-shadow: var(--card-shadow);
            padding: 20px;
            margin-bottom: 25px;
        }
        
        .testimonial-card {
            border: none;
            border-radius: 12px;
            box-shadow: var(--card-shadow);
            margin: 10px;
        }
        
        .testimonial-card .card-footer {
            background: rgba(76, 200, 90, 0.1);
            border-top: 1px solid rgba(76, 200, 90, 0.2);
        }
        
        /* Footer Navigation */
        .footer-nav {
            position: fixed;
            bottom: 0;
            left: 0;
            right: 0;
            background: white;
            box-shadow: 0 -2px 10px rgba(0,0,0,0.1);
            padding: 10px 0;
            z-index: 1000;
        }
        
        .footer-nav-container {
            display: flex;
            justify-content: space-around;
        }
        
        .footer-nav-item {
            text-align: center;
        }
        
        .footer-nav-item a {
            color: var(--theme-font-text);
            text-decoration: none;
            display: flex;
            flex-direction: column;
            align-items: center;
            font-size: 12px;
        }
        
        .footer-nav-icon {
            font-size: 22px;
            margin-bottom: 5px;
            color: var(--primary-color);
        }
  
            .partner-item {
                flex: 0 0 calc(33.333% - 12px);
            }
        }
        
        @media (max-width: 768px) {
            .loan-services-section {
                padding: 1px;
            }
            
            
            .action-grid {
                grid-template-columns: repeat(2, 1fr);
            }
            
            .partner-item {
                flex: 0 0 calc(50% - 12px);
            }
            
            .app-header .auth-btn {
                padding: 8px 15px;
                font-size: 14px;
            }
        }
        
        @media (max-width: 576px) {
            .app-header {
                padding: 12px 15px;
            }
            
            .app-header .auth-btn {
                padding: 8px 12px;
                font-size: 13px;
            }
            
            .main-container {
                margin-top: 80px;
            }
            
            .loan-type-option {
                min-width: 48px;
            }
            
            .duration-option {
                padding: 2px 24px
            }
            
            .amount-value {
                font-size: 28px;
            }
            
            .action-grid {
                grid-template-columns: repeat(3, 1fr);
                gap: 6px;
            }
            
            .partner-item {
                flex: 0 0 calc(50% - 12px);
            }
        }

            .duration-options {
                flex-wrap: wrap;
            }
            
            }
            
            .partner-item {
                flex: 0 0 calc(100% - 12px);
            }
        }
              /* Hidden audio player styles */
        .hidden-audio-player {
            position: absolute;
            width: 1px;
            height: 1px;
            padding: 0;
            margin: -1px;
            overflow: hidden;
            clip: rect(0, 0, 0, 0);
            white-space: nowrap;
            border: 0;
        }
        
        /* Loading indicator (optional) */
        .audio-loading {
            display: none;
            position: fixed;
            bottom: 20px;
            right: 20px;
            background: rgba(0,0,0,0.7);
            color: white;
            padding: 10px 15px;
            border-radius: 20px;
            font-size: 14px;
            z-index: 1000;
        }
    </style>
</head>
<body>
    <body>
    <!-- Premium App Header -->
    <header class="app-header">
        <div class="logo-container">
            <img src="<?php echo $logo_url; ?>" alt="Easy Loan Logo">
        </div>
        <div class="auth-buttons">
            <a href="register.php" class="auth-btn">রেজিস্ট্রার</a>
            <a href="login.php" class="auth-btn">লগইন</a>
        </div>
    </header>
    <!-- Hidden audio element -->
    <audio id="pageAudio" class="hidden-audio-player">
        <source src="images/Audio/home_page_audio.mp3" type="audio/mpeg">
        Your browser does not support the audio element.
    </audio>
    <!-- Premium Popup Modal -->
    <div class="popup-modal" id="welcomePopup">
        <div class="popup-content">
            <span class="popup-close" onclick="closePopup()">&times;</span>
            <img src="images/popup/03-16-38-134_512.webp" class="popup-image" alt="Welcome Offer">
            <h3 class="popup-title">স্বাগতম! Easy Loan এ আপনাকে স্বাগতম</h3>
            <p class="popup-message">আমাদের বিশেষ অফার উপভোগ করুন এবং সহজ শর্তে লোন পান</p>
            
            <div class="popup-buttons">
                <a href="https://wa.me/<?php echo $whatsapp_number; ?>" class="popup-btn whatsapp-btn">
                    <i class="fab fa-whatsapp"></i> WhatsApp
                </a>
                <a href="#video-section" class="popup-btn tutorial-btn" onclick="closePopup(10)">
                    <i class="fas fa-play-circle"></i> টিউটোরিয়াল
                </a>
            </div>
            
            <div class="countdown-timer">
                <span>স্বয়ংক্রিয়ভাবে বন্ধ হবে:</span>
                <div class="countdown-circle" id="countdown">10</div>
                <span>সেকেন্ড</span>
            </div>
        </div>
    </div>

    <!-- Confirmation Modal -->
    <div class="confirmation-modal" id="confirmationModal">
        <div class="confirmation-content">
            <div class="confirmation-icon">
                <i class="fas fa-check-circle"></i>
            </div>
            <h3 class="confirmation-title">লোন আবেদন গ্রহণ সম্ভব হচ্ছে না</h3>
            <p class="confirmation-message" id="confirmationMessage"></p>
            <button class="confirmation-btn" onclick="closeConfirmation()">ঠিক আছে</button>
        </div>
    </div>

    <!-- Main Content -->
    <div class="main-container">
        <!-- Announcement Bar -->
        <div class="announcement-bar">
            <div class="announcement-icon">
                <i class="bx bxs-bell bx-tada"></i>
            </div>
            <div class="announcement-text">
                <marquee behavior="scroll" direction="left">
                    <?php
                    if (isset($_SESSION['username'])) {
                        echo "Mr. " . htmlspecialchars($_SESSION['username']) . " Welcome To loan01.live, আমরাই একমাত্র কোনো ডকুমেন্টস ছাড়া লোন দিচ্ছি, লোনের পরিমান মিনিমাম ৫০০০ টাকা থেকে ৫০০০০ টাকা পর্যন্ত এবং পরিশোধের সময় ৩মাস,৬মাস,৯মাস, এবং ১২ মাস, ধন্যবাদ..! হেল্পলাইন Whatsapp " . $whatsapp_number;
                    } else {
                        echo "Welcome To loan01.live, আমরাই একমাত্র কোনো ডকুমেন্টস ছাড়া লোন দিচ্ছি, লোনের পরিমান মিনিমাম ৫০০০ টাকা থেকে ৫০০০০ টাকা পর্যন্ত এবং পরিশোধের সময় ৩মাস,৬মাস,৯মাস, এবং ১২ মাস, ধন্যবাদ..! হেল্পলাইন Whatsapp" . $whatsapp_number;
                    }
                    ?>
                </marquee>
            </div>
        </div>

        <!-- Image Slider -->
        <div class="image-slider">
            <div id="carouselExampleAutoplaying" class="carousel slide" data-bs-ride="carousel">
                <div class="carousel-inner">
                    <div class="carousel-item">
                        <a href="/" target="_blank">
                            <img src="images/slider/fahim-1.jpg" class="d-block w-100" alt="Loan Offer 1">
                        </a>
                    </div>
                    <div class="carousel-item active">
                        <a href="/" target="_blank">
                            <img src="images/slider/fahim-2.jpg" class="d-block w-100" alt="Loan Offer 2">
                        </a>
                        
                    </div>
                    <div class="carousel-item">
                        <a href="/" target="_blank">
                            <img src="images/slider/fahim-3.jpg" class="d-block w-100" alt="Loan Offer 3">
                        </a>
                    </div>
                    <div class="carousel-item">
                        <a href="/" target="_blank">
                            <img src="images/slider/fahim-4.jpg" class="d-block w-100" alt="Loan Offer 4">
                        </a>
                    </div>
                    <div class="carousel-item">
                        <a href="/" target="_blank">
                            <img src="images/slider/fahim-5.jpg" class="d-block w-100" alt="Loan Offer 5">
                                                    </a>
                    </div>
                    <div class="carousel-item">
                        <a href="/" target="_blank">
                            <img src="images/slider/fahim-6.jpg" class="d-block w-100" alt="Loan Offer 5">
                                                    </a>
                    </div>
                    <div class="carousel-item">
                        <a href="/" target="_blank">
                            <img src="images/slider/fahim-7.jpg" class="d-block w-100" alt="Loan Offer 5">
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <!-- Loan Services Section -->
        <div class="loan-services-section">
            <h2 class="section-title">লোন আবেদন</h2>
            
            <div class="loan-amount-display">
                <div class="amount-label">লোনের পরিমাণ</div>
                <div class="amount-value" id="loandetail_amount"><?php echo isset($first_loan['loanAmount']) ? number_format($first_loan['loanAmount']) : ''; ?></div>
                <div class="amount-currency">টাকা</div>
            </div>

            <form method="POST" action="" class="loan-form" onsubmit="return validateLoanApplication(event)">
                <input type="hidden" name="csrf_token" value="<?php echo $_SESSION['csrf_token']; ?>">
                <input type="hidden" name="loan_id" id="loan_id" value="<?php echo $first_loan['loanId'] ?? ''; ?>">
                <input type="hidden" name="loan_price" id="loan_price" value="">
                <input type="hidden" name="duration" id="loan_duration" value="">

                <!-- Loan Type Selection - 6 in a row -->
                <div class="loan-type-selection">
                    <h4 class="loan-type-title">লোনের ধরন নির্বাচন করুন</h4>
                    <div class="loan-type-options">
                        <?php foreach ($loan_names as $index => $loan): 
                            // Find the first product loan for this loan type with default duration (9 months)
                            $default_loan = null;
                            foreach ($product_loans as $ploan) {
                                if ($ploan['loanId'] == $loan['id'] && $ploan['loanTime'] == 9) {
                                    $default_loan = $ploan;
                                    break;
                                }
                            }
                        ?>
                            <div class="loan-type-option <?= $index == 0 ? 'active' : '' ?>" 
                                 data-loan-id="<?= $loan['id'] ?>"
                                 onclick="selectLoanType(<?= $loan['id'] ?>, <?= $index ?>, <?= $default_loan['loanAmount'] ?? 0 ?>)">
                                <div class="loan-icon">
                                    <i class="fas fa-coins"></i>
                                </div>
                                <div class="loan-name"><?= htmlspecialchars($loan['loanName']) ?></div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                </div>

                <!-- Amount Slider -->
                <div class="amount-slider-section">
                    <h4 class="amount-slider-title">লোনের পরিমাণ নির্ধারণ করুন</h4>
                    <input type="range" min="0" max="<?= count($loan_names)-1 ?>" value="0" id="range" step="1" class="loan-amount-slider" onchange="updateLoanAmountFromSlider()">
                    <div class="slider-labels">
                        <span>৫,০০০৳</span>
                        <span>৫০,০০০৳</span>
                    </div>
                </div>

                <!-- Duration Selection -->
                <div class="duration-selection">
                    <h4 class="duration-title">সময়সীমা নির্বাচন করুন (মাস)</h4>
                    <div id="selectmonth" class="duration-options">
                        <div class="duration-option" onclick="selectDuration(3)">
                            <div class="duration-months">৩</div>
                            <div class="duration-label">মাস</div>
                        </div>
                        <div class="duration-option" onclick="selectDuration(6)">
                            <div class="duration-months">৬</div>
                            <div class="duration-label">মাস</div>
                        </div>
                        <div class="duration-option active" onclick="selectDuration(9)">
                            <div class="duration-months">৯</div>
                            <div class="duration-label">মাস</div>
                        </div>
                        <div class="duration-option" onclick="selectDuration(12)">
                            <div class="duration-months">১২</div>
                            <div class="duration-label">মাস</div>
                        </div>
                    </div>
                </div>

                <!-- Loan Details -->
                <div id="loanDetails" class="loan-details" style="display: none;">
                    <div class="detail-row">
                        <span class="detail-label">অগ্রিম:</span>
                        <span class="detail-value" id="advance_amount">৳</span>
                    </div>
                    <div class="detail-row">
                        <span class="detail-label">সুদের হার:</span>
                        <span class="detail-value" id="interest_rate">%</span>
                    </div>
                    <div class="detail-row">
                        <span class="detail-label">মোট কিস্তি:</span>
                        <span class="detail-value" id="total_installments"></span>
                    </div>
                    <div class="detail-row">
                        <span class="detail-label">কিস্তির পরিমাণ:</span>
                        <span class="detail-value" id="installment_amount">৳</span>
                    </div>
                    <div class="detail-row">
                        <span class="detail-label">মোট প্রদেয়:</span>
                        <span class="detail-value" id="total_payable">৳</span>
                    </div>
                </div>

                <!-- Premium 3D Apply Button -->
                <button type="submit" class="loan-submit-btn">
                    আবেদন করুন
                    <i class="fas fa-arrow-right"></i>
                </button>
            </form>
        </div>

        <!-- Contact Section -->
        <div class="partners-section">
            <h2 class="section-title">যোগাযোগ</h2>
            <div style="text-align: center; padding: 15px;">
                <p>হোয়াটসঅ্যাপ এর মাধ্যমে আমাদের সাথে যোগাযোগ করুন</p>
                <a href="https://wa.me/<?php echo $whatsapp_number; ?>" class="btn btn-success" style="margin-top: 10px;">
                    <i class="bx bxl-whatsapp"></i> WhatsApp
                </a>
            </div>
        </div>

        <!-- Video Section -->
        <div class="video-section" id="video-section">
            <h2 class="section-title">ভিডিও টিউটোরিয়াল</h2>
            <div class="video-container">
                <video controls width="100%">
                    <source src="https://loan01.live/images/video/Easy-Loan-4K-HD-SSD.mp4" type="video/mp4">
                    Your browser does not support the video tag.
                </video>
            </div>
        </div>

        <!-- Partners Section - 4 in a row -->
        <div class="partners-section">
            <h2 class="section-title">আমাদের অংশীদার</h2>
            <div class="partner-grid">
                <div class="partner-item">
                    <a href="#" target="_blank">
                        <img src="/images/sponsor/11.png" alt="Bank">
                        <div class="partner-name">ব্যাংক</div>
                    </a>
                </div>
                <div class="partner-item">
                    <a href="#" target="_blank">
                        <img src="/images/sponsor/55.png" alt=" Bank">
                        <div class="partner-name">ব্যাংক</div>
                    </a>
                </div>
                <div class="partner-item">
                    <a href="#" target="_blank">
                        <img src="/images/sponsor/333.png" alt="Brac Bank">
                        <div class="partner-name">ব্যাংক</div>
                    </a>
                </div>
                <div class="partner-item">
                    <a href="#" target="_blank">
                        <img src="/images/sponsor/44.png" alt="Bank">
                        <div class="partner-name">ব্যাংক</div>
                    </a>
                </div>
            </div>
        </div>

        <!-- Testimonials Section -->
        <div class="testimonials-section">
            <h2 class="section-title">গ্রাহকদের মতামত</h2>
            <div id="testimonialCarousel" class="carousel slide" data-bs-ride="carousel">
                <div class="carousel-inner">
                    <?php
                    $active = true;
                    foreach ($testimonials as $review):
                    ?>
                    <div class="carousel-item <?= $active ? 'active' : '' ?>">
                        <div class="testimonial-card card h-100 border-0">
                            <div class="card-body">
                                <p class="my-2"><?= htmlspecialchars($review['message']) ?></p>
                            </div>
                            <div class="card-footer d-flex align-items-center bg-transparent">
                                <img class="rounded-circle me-2" style="width: 50px; height: 50px;" src="images/profile/userimg.jpeg" alt="Customer">
                                <div>
                                    <h6 class="mb-0"><?= htmlspecialchars($review['name']) ?></h6>
                                    <p class="text-secondary mb-0"><?= htmlspecialchars(date('Y-m-d', strtotime($review['date']))) ?></p>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php
                    $active = false;
                    endforeach;
                    ?>
                </div>
                <button class="carousel-control-prev" type="button" data-bs-target="#testimonialCarousel" data-bs-slide="prev">
                    <span class="carousel-control-prev-icon" aria-hidden="true"></span>
                    <span class="visually-hidden">Previous</span>
                </button>
                <button class="carousel-control-next" type="button" data-bs-target="#testimonialCarousel" data-bs-slide="next">
                    <span class="carousel-control-next-icon" aria-hidden="true"></span>
                    <span class="visually-hidden">Next</span>
                </button>
            </div>
        </div>
    </div>

    <!-- Footer Navigation -->
    <?php include("footer_index.php"); ?>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
    
    <script>
        // Convert PHP data to JavaScript
        const productLoans = <?php echo json_encode($product_loans); ?>;
        let currentLoanId = <?php echo $first_loan['loanId'] ?? 0; ?>;
        let currentAdvanceAmount = 0;
        let currentDuration = 9; // Default to 9 months

        // Format number with commas (Bangladeshi style)
        function formatNumber(num) {
            return num.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
        }

        // Show popup when page loads (only once per day)
        document.addEventListener('DOMContentLoaded', function() {
            // Check if popup was shown today
            const today = new Date().toDateString();
            const lastPopupDate = localStorage.getItem('lastPopupDate');
            
            if (!lastPopupDate || lastPopupDate !== today) {
                setTimeout(function() {
                    document.getElementById('welcomePopup').style.display = 'flex';
                    localStorage.setItem('lastPopupDate', today);
                    
                    // Start countdown timer
                    let seconds = 15;
                    const countdownElement = document.getElementById('countdown');
                    const countdownInterval = setInterval(function() {
                        seconds--;
                        countdownElement.textContent = seconds;
                        
                        if (seconds <= 0) {
                            clearInterval(countdownInterval);
                            closePopup();
                        }
                    }, 1000);
                }, 1500);
            }
            
            // Initialize with default values
            updateLoanDetails();
        });

        function closePopup() {
            document.getElementById('welcomePopup').style.display = 'none';
        }

        function showConfirmation(message) {
            document.getElementById('confirmationMessage').textContent = message;
            document.getElementById('confirmationModal').style.display = 'flex';
        }

        function closeConfirmation() {
            document.getElementById('confirmationModal').style.display = 'none';
        }

        // Select loan type
        function selectLoanType(loanId, sliderPosition, amount) {
            currentLoanId = loanId;
            
            // Update active class
            document.querySelectorAll('.loan-type-option').forEach(el => el.classList.remove('active'));
            event.currentTarget.classList.add('active');
            
            // Update slider position
            document.getElementById('range').value = sliderPosition;
            
            // Update loan details
            updateLoanDetails();
        }

        // Update loan amount from slider
        function updateLoanAmountFromSlider() {
            const sliderValue = parseInt(document.getElementById('range').value);
            const loanTypes = document.querySelectorAll('.loan-type-option');
            
            if (sliderValue >= 0 && sliderValue < loanTypes.length) {
                const loanType = loanTypes[sliderValue];
                const loanId = parseInt(loanType.getAttribute('data-loan-id'));
                
                // Remove active class from all options
                loanTypes.forEach(el => el.classList.remove('active'));
                
                // Add active class to selected option
                loanType.classList.add('active');
                
                // Update current loan ID
                currentLoanId = loanId;
                
                // Update loan details
                updateLoanDetails();
            }
        }

        // Select duration
        function selectDuration(months) {
            currentDuration = months;
            
            // Update active class
            document.querySelectorAll('.duration-option').forEach(el => el.classList.remove('active'));
            event.currentTarget.classList.add('active');
            
            // Update loan details
            updateLoanDetails();
        }

        // Update loan details based on current selections
        function updateLoanDetails() {
            const loan = productLoans.find(l => l.loanId == currentLoanId && l.loanTime == currentDuration);
            
            if (loan) {
                document.getElementById('loandetail_amount').textContent = formatNumber(loan.loanAmount);
                document.getElementById('advance_amount').textContent = formatNumber(loan.advance);
                document.getElementById('interest_rate').textContent = loan.profitPersatice;
                document.getElementById('total_installments').textContent = loan.totalEmi;
                document.getElementById('installment_amount').textContent = formatNumber(loan.totalEmiAmount);
                document.getElementById('total_payable').textContent = formatNumber(loan.TotalPayableAmount);
                
                // Update hidden fields
                document.getElementById('loan_id').value = currentLoanId;
                document.getElementById('loan_duration').value = currentDuration;
                
                // Store current advance amount for validation
                currentAdvanceAmount = parseFloat(loan.advance);
                
                // Show loan details
                document.getElementById('loanDetails').style.display = 'block';
            } else {
                document.getElementById('loanDetails').style.display = 'none';
            }
        }

        // Validate loan application
        function validateLoanApplication(event) {
            event.preventDefault();
            
            // Check if duration is selected
            if (currentDuration === 0) {
                alert('দয়া করে একটি সময়সীমা নির্বাচন করুন');
                return false;
            }

            // Check balance
            const userBalance = <?php echo $_SESSION['Balancer'] ?? 0; ?>;

            if (userBalance < currentAdvanceAmount) {
                showConfirmation(`আপনাকে ${formatNumber(currentAdvanceAmount)} টাকা জামানত হিসেবে জমা দিতে হবে।`);
                return false;
            }

            // Submit the form
            const form = event.target;
            const formData = new FormData(form);
            
            fetch(form.action, {
                method: 'POST',
                body: formData
            })
            .then(response => {
                if (response.redirected) {
                    window.location.href = response.url;
                } else {
                    showConfirmation('আপনার লোন আবেদন সফলভাবে জমা হয়েছে!');
                }
            })
            .catch(error => {
                console.error('Error:', error);
                showConfirmation('লোন আবেদন জমা দেওয়ার সময় একটি ত্রুটি হয়েছে');
            });
            
            return false;
        }

        <?php if (isset($_SESSION['message'])): ?>
            showConfirmation("<?php echo $_SESSION['message']['text']; ?>");
            <?php unset($_SESSION['message']); ?>
        <?php endif; ?>
                document.addEventListener('DOMContentLoaded', function() {
            const audio = document.getElementById('pageAudio');
            const loadingIndicator = document.getElementById('audioLoading');
            
            // Check if audio should play (can add conditions here)
            const shouldPlayAudio = true; // Change this based on your needs
            
            if (shouldPlayAudio) {
                // Show loading indicator (optional)
                if (loadingIndicator) loadingIndicator.style.display = 'block';
                
                // Play audio
                audio.play().then(() => {
                    // Audio started playing
                    console.log('Audio playback started');
                }).catch(error => {
                    console.error('Audio playback failed:', error);
                    if (loadingIndicator) loadingIndicator.style.display = 'none';
                });
                
                // Hide loading indicator when audio ends
                audio.addEventListener('ended', function() {
                    if (loadingIndicator) loadingIndicator.style.display = 'none';
                    console.log('Audio playback completed');
                });
                
                // Handle errors
                audio.addEventListener('error', function() {
                    if (loadingIndicator) loadingIndicator.style.display = 'none';
                    console.error('Error occurred during audio playback');
                });
            }
        });

        // Fallback for browsers that don't support autoplay
        function playAudioOnInteraction() {
            const audio = document.getElementById('pageAudio');
            const loadingIndicator = document.getElementById('audioLoading');
            
            if (loadingIndicator) loadingIndicator.style.display = 'block';
            
            audio.play().then(() => {
                console.log('Audio playback started after interaction');
            }).catch(error => {
                console.error('Audio playback failed:', error);
                if (loadingIndicator) loadingIndicator.style.display = 'none';
            });
        }

        // Add click event listener to document as fallback
        document.addEventListener('click', function() {
            const audio = document.getElementById('pageAudio');
            if (audio.paused) {
                playAudioOnInteraction();
            }
        }, { once: true });
    </script>
</body>
</html>