<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

session_start();
// Redirect to login if not authenticated
if (!isset($_SESSION['user_id'])) {
    header("Location: index.php");
    exit();
}

?>

<html lang="en" itemscope="" itemtype="http://schema.org/WebPage" class="hydrated"><head>
    <!-- Required meta tags -->
    <meta charset="utf-8"><style data-styles="">ion-icon{visibility:hidden}.hydrated{visibility:inherit}</style>
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <title> Bank loan - Trusted service - Deposit Methods</title>
    <meta name="title" content="Loan365 - Trusted service - Deposit Methods">
    <meta name="description" content="DEVELOPER BY SRT LAB">
    <meta name="keywords" content="OK">
    <link rel="shortcut icon" href="https://loan365.live/assets/images/logoIcon/favicon.png" type="image/x-icon">


    <link rel="apple-touch-icon" href="https://loan365.live/assets/images/logoIcon/logo.png">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="black">
    <meta name="apple-mobile-web-app-title" content="Loan365 - Trusted service - Deposit Methods">

    <meta itemprop="name" content="Loan365 - Trusted service - Deposit Methods">
    <meta itemprop="description" content="">
    <meta itemprop="image" content="https://loan365.live/assets/images/default.png">

    <meta property="og:type" content="website">
    <meta property="og:title" content="DEVELOPER BY SRT LAB">
    <meta property="og:description" content="DEVELOPER BY SRT LAB">
    <meta property="og:image" content="https://loan365.live/assets/images/default.png">
    <meta property="og:image:type" content="image/jpg">
    <meta property="og:image:width" content="1180">
    <meta property="og:image:height" content="600">
    <meta property="og:url" content="https://loan365.live/user/deposit">

    <meta name="twitter:card" content="summary_large_image">
    <!-- CSS -->
    <link href="https://loan365.live/assets/global/css/bootstrap.min1.css" rel="stylesheet">
    <link href="https://loan365.live/assets/global/css/all.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://loan365.live/assets/templates/basic/css/vendor/nice-select.css">
    <link rel="stylesheet" href="https://loan365.live/assets/templates/basic/css/vendor/slick.css">
    <link rel="stylesheet" href="https://loan365.live/assets/templates/smartlab/css/style.css">
    <!-- JS -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.2.0/css/all.min.css">
    <script src="https://code.jquery.com/jquery-3.2.1.slim.min.js" integrity="sha384-KJ3o2DKtIkvYIK3UENzmM7KCkRr/rE9/Qpg6aAZGJwFDMVNA/GpGFF93hXpG5KkN" crossorigin="anonymous"></script>
    <script src="https://cdn.jsdelivr.net/npm/popper.js@1.12.9/dist/umd/popper.min.js" integrity="sha384-ApNbgh9B+Y1QKtv3Rn7W3mgPxhU9K/ScQsAP7hUibX39j7fakFPskvXusvfa0b4Q" crossorigin="anonymous"></script>


    <link rel="stylesheet" href="https://loan365.live/assets/templates/smartlab/css/color.php?color1=2475c9&amp;color2=2475c9">
    <style>
        .language .nic-select , .language .nice-select {
            height: 32px !important;
            width: 53px !important;
            line-height: 30px !important;
            padding-left: 2px !important;
            padding-right: 2px !important;
            border-radius:5px !important;
        }
        .loader-n {
            background: #2475c9;
        }

        #errorToast {
            display: none;
        }
    </style>
    <style>*, ::before, ::after{--tw-border-spacing-x:0;--tw-border-spacing-y:0;--tw-translate-x:0;--tw-translate-y:0;--tw-rotate:0;--tw-skew-x:0;--tw-skew-y:0;--tw-scale-x:1;--tw-scale-y:1;--tw-pan-x: ;--tw-pan-y: ;--tw-pinch-zoom: ;--tw-scroll-snap-strictness:proximity;--tw-gradient-from-position: ;--tw-gradient-via-position: ;--tw-gradient-to-position: ;--tw-ordinal: ;--tw-slashed-zero: ;--tw-numeric-figure: ;--tw-numeric-spacing: ;--tw-numeric-fraction: ;--tw-ring-inset: ;--tw-ring-offset-width:0px;--tw-ring-offset-color:#fff;--tw-ring-color:rgb(59 130 246 / 0.5);--tw-ring-offset-shadow:0 0 #0000;--tw-ring-shadow:0 0 #0000;--tw-shadow:0 0 #0000;--tw-shadow-colored:0 0 #0000;--tw-blur: ;--tw-brightness: ;--tw-contrast: ;--tw-grayscale: ;--tw-hue-rotate: ;--tw-invert: ;--tw-saturate: ;--tw-sepia: ;--tw-drop-shadow: ;--tw-backdrop-blur: ;--tw-backdrop-brightness: ;--tw-backdrop-contrast: ;--tw-backdrop-grayscale: ;--tw-backdrop-hue-rotate: ;--tw-backdrop-invert: ;--tw-backdrop-opacity: ;--tw-backdrop-saturate: ;--tw-backdrop-sepia: ;--tw-contain-size: ;--tw-contain-layout: ;--tw-contain-paint: ;--tw-contain-style: }::backdrop{--tw-border-spacing-x:0;--tw-border-spacing-y:0;--tw-translate-x:0;--tw-translate-y:0;--tw-rotate:0;--tw-skew-x:0;--tw-skew-y:0;--tw-scale-x:1;--tw-scale-y:1;--tw-pan-x: ;--tw-pan-y: ;--tw-pinch-zoom: ;--tw-scroll-snap-strictness:proximity;--tw-gradient-from-position: ;--tw-gradient-via-position: ;--tw-gradient-to-position: ;--tw-ordinal: ;--tw-slashed-zero: ;--tw-numeric-figure: ;--tw-numeric-spacing: ;--tw-numeric-fraction: ;--tw-ring-inset: ;--tw-ring-offset-width:0px;--tw-ring-offset-color:#fff;--tw-ring-color:rgb(59 130 246 / 0.5);--tw-ring-offset-shadow:0 0 #0000;--tw-ring-shadow:0 0 #0000;--tw-shadow:0 0 #0000;--tw-shadow-colored:0 0 #0000;--tw-blur: ;--tw-brightness: ;--tw-contrast: ;--tw-grayscale: ;--tw-hue-rotate: ;--tw-invert: ;--tw-saturate: ;--tw-sepia: ;--tw-drop-shadow: ;--tw-backdrop-blur: ;--tw-backdrop-brightness: ;--tw-backdrop-contrast: ;--tw-backdrop-grayscale: ;--tw-backdrop-hue-rotate: ;--tw-backdrop-invert: ;--tw-backdrop-opacity: ;--tw-backdrop-saturate: ;--tw-backdrop-sepia: ;--tw-contain-size: ;--tw-contain-layout: ;--tw-contain-paint: ;--tw-contain-style: }/* ! tailwindcss v3.4.16 | MIT License | https://tailwindcss.com */*,::after,::before{box-sizing:border-box;border-width:0;border-style:solid;border-color:#e5e7eb}::after,::before{--tw-content:''}:host,html{line-height:1.5;-webkit-text-size-adjust:100%;-moz-tab-size:4;tab-size:4;font-family:ui-sans-serif, system-ui, sans-serif, "Apple Color Emoji", "Segoe UI Emoji", "Segoe UI Symbol", "Noto Color Emoji";font-feature-settings:normal;font-variation-settings:normal;-webkit-tap-highlight-color:transparent}body{margin:0;line-height:inherit}hr{height:0;color:inherit;border-top-width:1px}abbr:where([title]){-webkit-text-decoration:underline dotted;text-decoration:underline dotted}h1,h2,h3,h4,h5,h6{font-size:inherit;font-weight:inherit}a{color:inherit;text-decoration:inherit}b,strong{font-weight:bolder}code,kbd,pre,samp{font-family:ui-monospace, SFMono-Regular, Menlo, Monaco, Consolas, "Liberation Mono", "Courier New", monospace;font-feature-settings:normal;font-variation-settings:normal;font-size:1em}small{font-size:80%}sub,sup{font-size:75%;line-height:0;position:relative;vertical-align:baseline}sub{bottom:-.25em}sup{top:-.5em}table{text-indent:0;border-color:inherit;border-collapse:collapse}button,input,optgroup,select,textarea{font-family:inherit;font-feature-settings:inherit;font-variation-settings:inherit;font-size:100%;font-weight:inherit;line-height:inherit;letter-spacing:inherit;color:inherit;margin:0;padding:0}button,select{text-transform:none}button,input:where([type=button]),input:where([type=reset]),input:where([type=submit]){-webkit-appearance:button;background-color:transparent;background-image:none}:-moz-focusring{outline:auto}:-moz-ui-invalid{box-shadow:none}progress{vertical-align:baseline}::-webkit-inner-spin-button,::-webkit-outer-spin-button{height:auto}[type=search]{-webkit-appearance:textfield;outline-offset:-2px}::-webkit-search-decoration{-webkit-appearance:none}::-webkit-file-upload-button{-webkit-appearance:button;font:inherit}summary{display:list-item}blockquote,dd,dl,figure,h1,h2,h3,h4,h5,h6,hr,p,pre{margin:0}fieldset{margin:0;padding:0}legend{padding:0}menu,ol,ul{list-style:none;margin:0;padding:0}dialog{padding:0}textarea{resize:vertical}input::placeholder,textarea::placeholder{opacity:1;color:#9ca3af}[role=button],button{cursor:pointer}:disabled{cursor:default}audio,canvas,embed,iframe,img,object,svg,video{display:block;vertical-align:middle}img,video{max-width:100%;height:auto}[hidden]:where(:not([hidden=until-found])){display:none}.container{width:100%}@media (min-width: 640px){.container{max-width:640px}}@media (min-width: 768px){.container{max-width:768px}}@media (min-width: 1024px){.container{max-width:1024px}}@media (min-width: 1280px){.container{max-width:1280px}}@media (min-width: 1536px){.container{max-width:1536px}}.pointer-events-none{pointer-events:none}.absolute{position:absolute}.relative{position:relative}.-top-1\.5{top:-0.375rem}.left-0{left:0px}.m-5{margin:1.25rem}.mx-auto{margin-left:auto;margin-right:auto}.mb-3{margin-bottom:0.75rem}.mt-1{margin-top:0.25rem}.mt-5{margin-top:1.25rem}.mt-6{margin-top:1.5rem}.flex{display:flex}.grid{display:grid}.hidden{display:none}.h-11{height:2.75rem}.h-12{height:3rem}.h-14{height:3.5rem}.h-7{height:1.75rem}.h-8{height:2rem}.h-full{height:100%}.min-h-screen{min-height:100vh}.w-12{width:3rem}.w-6{width:1.5rem}.w-7{width:1.75rem}.w-8{width:2rem}.w-full{width:100%}.min-w-\[200px\]{min-width:200px}.max-w-lg{max-width:32rem}.cursor-pointer{cursor:pointer}.select-none{-webkit-user-select:none;user-select:none}.flex-col{flex-direction:column}.flex-wrap{flex-wrap:wrap}.items-center{align-items:center}.justify-center{justify-content:center}.gap-3{gap:0.75rem}.gap-5{gap:1.25rem}.overflow-hidden{overflow:hidden}.whitespace-nowrap{white-space:nowrap}.rounded-full{border-radius:9999px}.rounded-lg{border-radius:0.5rem}.rounded-md{border-radius:0.375rem}.\!border{border-width:1px !important}.border{border-width:1px}.border-4{border-width:4px}.border-r{border-right-width:1px}.border-none{border-style:none}.\!border-gray-300{--tw-border-opacity:1 !important;border-color:rgb(209 213 219 / var(--tw-border-opacity, 1)) !important}.border-red-300{--tw-border-opacity:1;border-color:rgb(252 165 165 / var(--tw-border-opacity, 1))}.border-red-500{--tw-border-opacity:1;border-color:rgb(239 68 68 / var(--tw-border-opacity, 1))}.border-t-transparent{border-top-color:transparent}.bg-\[\#F6BE00\]{--tw-bg-opacity:1;background-color:rgb(246 190 0 / var(--tw-bg-opacity, 1))}.bg-\[\#ebebeb\]{--tw-bg-opacity:1;background-color:rgb(235 235 235 / var(--tw-bg-opacity, 1))}.bg-transparent{background-color:transparent}.bg-white{--tw-bg-opacity:1;background-color:rgb(255 255 255 / var(--tw-bg-opacity, 1))}.p-3{padding:0.75rem}.p-4{padding:1rem}.px-3{padding-left:0.75rem;padding-right:0.75rem}.px-6{padding-left:1.5rem;padding-right:1.5rem}.py-1\.5{padding-top:0.375rem;padding-bottom:0.375rem}.py-3{padding-top:0.75rem;padding-bottom:0.75rem}.py-5{padding-top:1.25rem;padding-bottom:1.25rem}.pb-10{padding-bottom:2.5rem}.pl-4{padding-left:1rem}.text-left{text-align:left}.text-center{text-align:center}.align-middle{vertical-align:middle}.font-sans{font-family:ui-sans-serif, system-ui, sans-serif, "Apple Color Emoji", "Segoe UI Emoji", "Segoe UI Symbol", "Noto Color Emoji"}.text-\[11px\]{font-size:11px}.text-lg{font-size:1.125rem;line-height:1.75rem}.text-sm{font-size:0.875rem;line-height:1.25rem}.text-xl{font-size:1.25rem;line-height:1.75rem}.text-xs{font-size:0.75rem;line-height:1rem}.font-bold{font-weight:700}.font-normal{font-weight:400}.uppercase{text-transform:uppercase}.leading-tight{line-height:1.25}.text-\[\#7d0984\]{--tw-text-opacity:1;color:rgb(125 9 132 / var(--tw-text-opacity, 1))}.text-gray-900{--tw-text-opacity:1;color:rgb(17 24 39 / var(--tw-text-opacity, 1))}.text-red-500{--tw-text-opacity:1;color:rgb(239 68 68 / var(--tw-text-opacity, 1))}.text-red-700{--tw-text-opacity:1;color:rgb(185 28 28 / var(--tw-text-opacity, 1))}.text-white{--tw-text-opacity:1;color:rgb(255 255 255 / var(--tw-text-opacity, 1))}.shadow{--tw-shadow:0 1px 3px 0 rgb(0 0 0 / 0.1), 0 1px 2px -1px rgb(0 0 0 / 0.1);--tw-shadow-colored:0 1px 3px 0 var(--tw-shadow-color), 0 1px 2px -1px var(--tw-shadow-color);box-shadow:var(--tw-ring-offset-shadow, 0 0 #0000), var(--tw-ring-shadow, 0 0 #0000), var(--tw-shadow)}.shadow-none{--tw-shadow:0 0 #0000;--tw-shadow-colored:0 0 #0000;box-shadow:var(--tw-ring-offset-shadow, 0 0 #0000), var(--tw-ring-shadow, 0 0 #0000), var(--tw-shadow)}.shadow-blue-500\/20{--tw-shadow-color:rgb(59 130 246 / 0.2);--tw-shadow:var(--tw-shadow-colored)}.outline{outline-style:solid}.outline-0{outline-width:0px}.transition-all{transition-property:all;transition-timing-function:cubic-bezier(0.4, 0, 0.2, 1);transition-duration:150ms}.placeholder\:text-gray-500::placeholder{--tw-text-opacity:1;color:rgb(107 114 128 / var(--tw-text-opacity, 1))}.before\:pointer-events-none::before{content:var(--tw-content);pointer-events:none}.before\:mr-1::before{content:var(--tw-content);margin-right:0.25rem}.before\:mt-\[6\.5px\]::before{content:var(--tw-content);margin-top:6.5px}.before\:box-border::before{content:var(--tw-content);box-sizing:border-box}.before\:block::before{content:var(--tw-content);display:block}.before\:h-1\.5::before{content:var(--tw-content);height:0.375rem}.before\:w-2\.5::before{content:var(--tw-content);width:0.625rem}.before\:rounded-tl-md::before{content:var(--tw-content);border-top-left-radius:0.375rem}.before\:border-l::before{content:var(--tw-content);border-left-width:1px}.before\:border-t::before{content:var(--tw-content);border-top-width:1px}.before\:transition-all::before{content:var(--tw-content);transition-property:all;transition-timing-function:cubic-bezier(0.4, 0, 0.2, 1);transition-duration:150ms}.after\:pointer-events-none::after{content:var(--tw-content);pointer-events:none}.after\:ml-1::after{content:var(--tw-content);margin-left:0.25rem}.after\:mt-\[6\.5px\]::after{content:var(--tw-content);margin-top:6.5px}.after\:box-border::after{content:var(--tw-content);box-sizing:border-box}.after\:block::after{content:var(--tw-content);display:block}.after\:h-1\.5::after{content:var(--tw-content);height:0.375rem}.after\:w-2\.5::after{content:var(--tw-content);width:0.625rem}.after\:flex-grow::after{content:var(--tw-content);flex-grow:1}.after\:rounded-tr-md::after{content:var(--tw-content);border-top-right-radius:0.375rem}.after\:border-r::after{content:var(--tw-content);border-right-width:1px}.after\:border-t::after{content:var(--tw-content);border-top-width:1px}.after\:transition-all::after{content:var(--tw-content);transition-property:all;transition-timing-function:cubic-bezier(0.4, 0, 0.2, 1);transition-duration:150ms}.placeholder-shown\:border:placeholder-shown{border-width:1px}.hover\:bg-\[\#F6BE00\]:hover{--tw-bg-opacity:1;background-color:rgb(246 190 0 / var(--tw-bg-opacity, 1))}.hover\:shadow-lg:hover{--tw-shadow:0 10px 15px -3px rgb(0 0 0 / 0.1), 0 4px 6px -4px rgb(0 0 0 / 0.1);--tw-shadow-colored:0 10px 15px -3px var(--tw-shadow-color), 0 4px 6px -4px var(--tw-shadow-color);box-shadow:var(--tw-ring-offset-shadow, 0 0 #0000), var(--tw-ring-shadow, 0 0 #0000), var(--tw-shadow)}.hover\:shadow-blue-500\/40:hover{--tw-shadow-color:rgb(59 130 246 / 0.4);--tw-shadow:var(--tw-shadow-colored)}.focus\:border-2:focus{border-width:2px}.focus\:border-none:focus{border-style:none}.focus\:\!border-gray-900:focus{--tw-border-opacity:1 !important;border-color:rgb(17 24 39 / var(--tw-border-opacity, 1)) !important}.focus\:border-green-500:focus{--tw-border-opacity:1;border-color:rgb(34 197 94 / var(--tw-border-opacity, 1))}.focus\:\!border-t-gray-900:focus{--tw-border-opacity:1 !important;border-top-color:rgb(17 24 39 / var(--tw-border-opacity, 1)) !important}.focus\:border-t-transparent:focus{border-top-color:transparent}.focus\:opacity-\[0\.85\]:focus{opacity:0.85}.focus\:shadow-none:focus{--tw-shadow:0 0 #0000;--tw-shadow-colored:0 0 #0000;box-shadow:var(--tw-ring-offset-shadow, 0 0 #0000), var(--tw-ring-shadow, 0 0 #0000), var(--tw-shadow)}.focus\:outline-0:focus{outline-width:0px}.active\:opacity-\[0\.85\]:active{opacity:0.85}.active\:shadow-none:active{--tw-shadow:0 0 #0000;--tw-shadow-colored:0 0 #0000;box-shadow:var(--tw-ring-offset-shadow, 0 0 #0000), var(--tw-ring-shadow, 0 0 #0000), var(--tw-shadow)}.disabled\:pointer-events-none:disabled{pointer-events:none}.disabled\:border-0:disabled{border-width:0px}.disabled\:opacity-50:disabled{opacity:0.5}.disabled\:shadow-none:disabled{--tw-shadow:0 0 #0000;--tw-shadow-colored:0 0 #0000;box-shadow:var(--tw-ring-offset-shadow, 0 0 #0000), var(--tw-ring-shadow, 0 0 #0000), var(--tw-shadow)}.peer:placeholder-shown ~ .peer-placeholder-shown\:text-sm{font-size:0.875rem;line-height:1.25rem}.peer:placeholder-shown ~ .peer-placeholder-shown\:leading-\[4\.1\]{line-height:4.1}.peer:placeholder-shown ~ .peer-placeholder-shown\:before\:border-transparent::before{content:var(--tw-content);border-color:transparent}.peer:placeholder-shown ~ .peer-placeholder-shown\:after\:border-transparent::after{content:var(--tw-content);border-color:transparent}.peer:focus ~ .peer-focus\:text-\[11px\]{font-size:11px}.peer:focus ~ .peer-focus\:leading-tight{line-height:1.25}.peer:focus ~ .peer-focus\:text-green-500{--tw-text-opacity:1;color:rgb(34 197 94 / var(--tw-text-opacity, 1))}.peer:focus ~ .peer-focus\:before\:border-l-2::before{content:var(--tw-content);border-left-width:2px}.peer:focus ~ .peer-focus\:before\:border-t-2::before{content:var(--tw-content);border-top-width:2px}.peer:focus ~ .peer-focus\:before\:\!border-green-500::before{content:var(--tw-content);--tw-border-opacity:1 !important;border-color:rgb(34 197 94 / var(--tw-border-opacity, 1)) !important}.peer:focus ~ .peer-focus\:after\:border-r-2::after{content:var(--tw-content);border-right-width:2px}.peer:focus ~ .peer-focus\:after\:border-t-2::after{content:var(--tw-content);border-top-width:2px}.peer:focus ~ .peer-focus\:after\:\!border-green-500::after{content:var(--tw-content);--tw-border-opacity:1 !important;border-color:rgb(34 197 94 / var(--tw-border-opacity, 1)) !important}.peer:disabled ~ .peer-disabled\:text-transparent{color:transparent}.peer:disabled ~ .peer-disabled\:before\:border-transparent::before{content:var(--tw-content);border-color:transparent}.peer:disabled ~ .peer-disabled\:after\:border-transparent::after{content:var(--tw-content);border-color:transparent}</style></head>

<body class="">



<div id="loader" style="display: none;">
    <div class="loader-n">
        <div class="l-one"></div>
        <div class="l-two"></div>
    </div>
</div>






<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<script src="https://cdn.tailwindcss.com"></script>
<link rel="preconnect" href="https://fonts.googleapis.com">
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin="">
<link href="https://fonts.googleapis.com/css2?family=Kanit:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&amp;display=swap" rel="stylesheet">
<style>
    * {
        font-family: Kanit,cursive;
        -webkit-touch-callout: none;
        -webkit-user-select: none;
        -moz-user-select: none;
        user-select: none;
        box-sizing: border-box;
        padding: 0;
        margin: 0;
    }

    #nprogress {
        pointer-events: none;
    }

    #nprogress .bar {
        background: #B72B41;
        position: fixed;
        z-index: 9999;
        top: 0;
        left: 0;
        width: 100%;
        height: 3px;
    }

    #nprogress .peg {
        display: block;
        position: absolute;
        right: 0px;
        width: 100px;
        height: 100%;
        box-shadow: 0 0 10px #B72B41, 0 0 5px #B72B41;
        opacity: 1;
        -webkit-transform: rotate(3deg) translate(0px, -4px);
        -ms-transform: rotate(3deg) translate(0px, -4px);
        transform: rotate(3deg) translate(0px, -4px);
    }

    #nprogress .spinner {
        display: block;
        position: fixed;
        z-index: 1031;
        top: 15px;
        right: 15px;
    }

    #nprogress .spinner-icon {
        width: 18px;
        height: 18px;
        box-sizing: border-box;
        border: solid 2px transparent;
        border-top-color: #B72B41;
        border-left-color: #B72B41;
        border-radius: 50%;
        -webkit-animation: nprogresss-spinner 400ms linear infinite;
        animation: nprogress-spinner 400ms linear infinite;
    }

    .nprogress-custom-parent {
        overflow: hidden;
        position: relative;
    }

    .nprogress-custom-parent #nprogress .spinner, .nprogress-custom-parent #nprogress .bar {
        position: absolute;
    }

    @-webkit-keyframes nprogress-spinner {
        0% {
            -webkit-transform: rotate(0deg);
        }

        100% {
            -webkit-transform: rotate(360deg);
        }
    }

    @keyframes nprogress-spinner {
        0% {
            transform: rotate(0deg);
        }

        100% {
            transform: rotate(360deg);
        }
    }
</style>


<div class="min-h-screen bg-[#ebebeb] pb-10">
    <a href="/" class="h-14 w-full bg-[#F6BE00] pl-4  gap-5 shadow text-white flex items-center ">
        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor" aria-hidden="true" class="h-7 font-bold cursor-pointer w-7">
            <path fill-rule="evenodd" d="M7.72 12.53a.75.75 0 010-1.06l7.5-7.5a.75.75 0 111.06 1.06L9.31 12l6.97 6.97a.75.75 0 11-1.06 1.06l-7.5-7.5z" clip-rule="evenodd"></path>
        </svg>
        <h2 class="text-xl font-bold text-white">Deposit </h2>
    </a>


    <div class="flex justify-center m-5 p-4 bg-white rounded-lg py-5 shadow hind">নোটিশ: মিনিমাম ডিপোজিট ৫০০ টাকা।</div>

    <div class="iziToast-capsule" style="height: auto;">
        <div data-izitoast-ref="1744219535268" class="iziToast fadeInUp iziToast-theme-light iziToast-color-red iziToast-animateInside iziToast-opened" id="errorToast">
            <div class="iziToast-body" style="padding-left: 33px;">
                <i class="iziToast-icon ico-error revealIn"></i>
                <div class="iziToast-texts">
                    <p class="iziToast-message slideIn">The currency field is required.</p>
                </div>
            </div>
            <button type="button" class="iziToast-close" onclick="closeToast()"></button>
            <div class="iziToast-progressbar">
                <div style="transition: width 3519ms linear; width: 0%;"></div>
            </div>
        </div>
    </div>


    <form action="manual.php" method="post" enctype="multipart/form-data">

        <div class="flex flex-col items-center justify-center m-5 p-4 bg-white rounded-lg py-5 shadow">

            <h2 class="mb-3 text-lg">Select Payment Method</h2>
            <input type="hidden" id="selected_payment_method" name="payment_method" value="">

            <div class="flex gap-5">

                <div class="deposit p-3 relative rounded-lg cursor-pointer border-4 border-red-300" data-id="1000" data-resource="{&quot;id&quot;:1,&quot;name&quot;:&quot;\u09ac\u09bf\u0995\u09be\u09b6&quot;,&quot;currency&quot;:&quot;BDT&quot;,&quot;symbol&quot;:&quot;&quot;,&quot;method_code&quot;:&quot;1000&quot;,&quot;gateway_alias&quot;:&quot;\u09ac\u09bf\u0995\u09be\u09b6&quot;,&quot;min_amount&quot;:&quot;500.00000000&quot;,&quot;max_amount&quot;:&quot;25000.00000000&quot;,&quot;percent_charge&quot;:&quot;0.00&quot;,&quot;fixed_charge&quot;:&quot;0.00000000&quot;,&quot;rate&quot;:&quot;1.00000000&quot;,&quot;image&quot;:null,&quot;created_at&quot;:&quot;2024-02-20T12:30:30.000000Z&quot;,&quot;updated_at&quot;:&quot;2025-04-05T15:21:24.000000Z&quot;,&quot;method&quot;:{&quot;id&quot;:61,&quot;form_id&quot;:&quot;6&quot;,&quot;code&quot;:&quot;1000&quot;,&quot;name&quot;:&quot;\u09ac\u09bf\u0995\u09be\u09b6&quot;,&quot;alias&quot;:&quot;\u09ac\u09bf\u0995\u09be\u09b6&quot;,&quot;image&quot;:null,&quot;status&quot;:true,&quot;supported_currencies&quot;:[],&quot;crypto&quot;:&quot;0&quot;,&quot;description&quot;:&quot;01306491363&quot;,&quot;created_at&quot;:&quot;2024-02-20T12:30:30.000000Z&quot;,&quot;updated_at&quot;:&quot;2025-04-05T15:21:24.000000Z&quot;}}" data-base_symbol="" onclick="toggleElements()">
                    <img src="/images/d-siam/payment.png" alt="" class="h-8  w-8 mx-auto">
                    <h2 class=" text-[#7d0984] text-sm font-bold">বিকাশ </h2>
                </div>

                <div class="deposit p-3 relative rounded-lg cursor-pointer border-4 border-red-300" data-id="1001" data-resource="{&quot;id&quot;:9,&quot;name&quot;:&quot;\u09a8\u0997\u09a6&quot;,&quot;currency&quot;:&quot;BDT&quot;,&quot;symbol&quot;:&quot;&quot;,&quot;method_code&quot;:&quot;1001&quot;,&quot;gateway_alias&quot;:&quot;\u09a8\u0997\u09a6&quot;,&quot;min_amount&quot;:&quot;500.00000000&quot;,&quot;max_amount&quot;:&quot;25000.00000000&quot;,&quot;percent_charge&quot;:&quot;0.00&quot;,&quot;fixed_charge&quot;:&quot;0.00000000&quot;,&quot;rate&quot;:&quot;1.00000000&quot;,&quot;image&quot;:null,&quot;created_at&quot;:&quot;2024-06-03T01:42:28.000000Z&quot;,&quot;updated_at&quot;:&quot;2025-03-28T14:30:02.000000Z&quot;,&quot;method&quot;:{&quot;id&quot;:63,&quot;form_id&quot;:&quot;9&quot;,&quot;code&quot;:&quot;1001&quot;,&quot;name&quot;:&quot;\u09a8\u0997\u09a6&quot;,&quot;alias&quot;:&quot;\u09a8\u0997\u09a6&quot;,&quot;image&quot;:null,&quot;status&quot;:true,&quot;supported_currencies&quot;:[],&quot;crypto&quot;:&quot;0&quot;,&quot;description&quot;:&quot;01798889632&quot;,&quot;created_at&quot;:&quot;2024-06-03T01:42:28.000000Z&quot;,&quot;updated_at&quot;:&quot;2025-03-28T14:29:02.000000Z&quot;}}" data-base_symbol="" onclick="toggleElements()">
                    <img src="/images/d-siam/payment.png" alt="" class="h-8  w-8 mx-auto">
                    <h2 class=" text-[#7d0984] text-sm font-bold">নগদ </h2>
                </div>

                <div class="deposit p-3 relative rounded-lg cursor-pointer border-4 border-red-300" data-id="1002" data-resource="{&quot;id&quot;:10,&quot;name&quot;:&quot;\u09b0\u0995\u09c7\u099f&quot;,&quot;currency&quot;:&quot;BDT&quot;,&quot;symbol&quot;:&quot;&quot;,&quot;method_code&quot;:&quot;1002&quot;,&quot;gateway_alias&quot;:&quot;\u09b0\u0995\u09c7\u099f&quot;,&quot;min_amount&quot;:&quot;500.00000000&quot;,&quot;max_amount&quot;:&quot;25000.00000000&quot;,&quot;percent_charge&quot;:&quot;0.00&quot;,&quot;fixed_charge&quot;:&quot;0.00000000&quot;,&quot;rate&quot;:&quot;1.00000000&quot;,&quot;image&quot;:null,&quot;created_at&quot;:&quot;2024-12-16T18:13:57.000000Z&quot;,&quot;updated_at&quot;:&quot;2025-03-28T21:15:14.000000Z&quot;,&quot;method&quot;:{&quot;id&quot;:64,&quot;form_id&quot;:&quot;10&quot;,&quot;code&quot;:&quot;1002&quot;,&quot;name&quot;:&quot;\u09b0\u0995\u09c7\u099f&quot;,&quot;alias&quot;:&quot;\u09b0\u0995\u09c7\u099f&quot;,&quot;image&quot;:null,&quot;status&quot;:true,&quot;supported_currencies&quot;:[],&quot;crypto&quot;:&quot;0&quot;,&quot;description&quot;:&quot;01623933861&quot;,&quot;created_at&quot;:&quot;2024-12-16T18:13:57.000000Z&quot;,&quot;updated_at&quot;:&quot;2025-03-28T21:15:14.000000Z&quot;}}" data-base_symbol="" onclick="toggleElements()">
                    <img src="/images/d-siam/payment.png" alt="" class="h-8  w-8 mx-auto">
                    <h2 class=" text-[#7d0984] text-sm font-bold">রকেট </h2>
                </div>


            </div>


        </div>



        <div class="flex flex-col items-center justify-center m-5 p-4 bg-white rounded-lg py-5 shadow">
            <h2 class="mb-3  text-xl ">Amount</h2>
            <div class="flex w-full max-w-lg items-center border justify-center border-red-300 rounded-lg overflow-hidden">
                <div class="h-12 w-12 flex items-center justify-center border-r border-red-300">
                    <svg stroke="currentColor" fill="currentColor" stroke-width="0" viewBox="0 0 640 512" class="h-8 cursor-pointer w-6 text-gray-900" height="1em" width="1em" xmlns="http://www.w3.org/2000/svg">
                        <path d="M320 144c-53.02 0-96 50.14-96 112 0 61.85 42.98 112 96 112 53 0 96-50.13 96-112 0-61.86-42.98-112-96-112zm40 168c0 4.42-3.58 8-8 8h-64c-4.42 0-8-3.58-8-8v-16c0-4.42 3.58-8 8-8h16v-55.44l-.47.31a7.992 7.992 0 0 1-11.09-2.22l-8.88-13.31a7.992 7.992 0 0 1 2.22-11.09l15.33-10.22a23.99 23.99 0 0 1 13.31-4.03H328c4.42 0 8 3.58 8 8v88h16c4.42 0 8 3.58 8 8v16zM608 64H32C14.33 64 0 78.33 0 96v320c0 17.67 14.33 32 32 32h576c17.67 0 32-14.33 32-32V96c0-17.67-14.33-32-32-32zm-16 272c-35.35 0-64 28.65-64 64H112c0-35.35-28.65-64-64-64V176c35.35 0 64-28.65 64-64h416c0 35.35 28.65 64 64 64v160z"></path>
                    </svg>
                </div>
                <div class="relative w-full min-w-[200px] h-11">
                    <input placeholder="Enter Amount" id="amount" required="" name="amount" type="number" class="peer w-full h-full bg-transparent text-blue-gray-700 font-sans font-normal outline outline-0 focus:outline-0 disabled:bg-blue-gray-50 disabled:border-0 transition-all placeholder-shown:border placeholder-shown:border-blue-gray-200 placeholder-shown:border-t-blue-gray-200 border focus:border-2 border-t-transparent focus:border-t-transparent text-sm px-3 py-3 rounded-md border-blue-gray-200 focus:border-green-500 !border !border-gray-300 focus:border-none border-none bg-white text-gray-900  placeholder:text-gray-500 focus:!border-gray-900 focus:!border-t-gray-900 " value="">
                    <label class="flex w-full h-full select-none pointer-events-none absolute left-0 font-normal peer-placeholder-shown:text-blue-gray-500 leading-tight peer-focus:leading-tight peer-disabled:text-transparent peer-disabled:peer-placeholder-shown:text-blue-gray-500 transition-all -top-1.5 peer-placeholder-shown:text-sm text-[11px] peer-focus:text-[11px] before:content[' '] before:block before:box-border before:w-2.5 before:h-1.5 before:mt-[6.5px] before:mr-1 peer-placeholder-shown:before:border-transparent before:rounded-tl-md before:border-t peer-focus:before:border-t-2 before:border-l peer-focus:before:border-l-2 before:pointer-events-none before:transition-all peer-disabled:before:border-transparent after:content[' '] after:block after:flex-grow after:box-border after:w-2.5 after:h-1.5 after:mt-[6.5px] after:ml-1 peer-placeholder-shown:after:border-transparent after:rounded-tr-md after:border-t peer-focus:after:border-t-2 after:border-r peer-focus:after:border-r-2 after:pointer-events-none after:transition-all peer-disabled:after:border-transparent peer-placeholder-shown:leading-[4.1] text-blue-gray-400 peer-focus:text-green-500 before:border-blue-gray-200 peer-focus:before:!border-green-500 after:border-blue-gray-200 peer-focus:after:!border-green-500 hidden">Mobile
                        Number </label>
                </div>
            </div>
            <p class="text-red-500 text-sm text-left w-full mt-1">Minimum deposit 500 BDT</p>

            <div class="mt-5 flex justify-center gap-3 flex-wrap">
                <div onclick="addAmount(500)" class="relative grid items-center font-sans font-bold uppercase whitespace-nowrap select-none border border-red-500 text-red-700 py-1.5 px-3 text-xs rounded-lg cursor-pointer" style="opacity: 1;">
                    <span class="">500</span>
                </div>
                <div onclick="addAmount(1000)" class="relative grid items-center font-sans font-bold uppercase whitespace-nowrap select-none border border-red-500 text-red-700 py-1.5 px-3 text-xs rounded-lg cursor-pointer" style="opacity: 1;">
                    <span class="">1000</span>
                </div>
                <div onclick="addAmount(2000)" class="relative grid items-center font-sans font-bold uppercase whitespace-nowrap select-none border border-red-500 text-red-700 py-1.5 px-3 text-xs rounded-lg cursor-pointer" style="opacity: 1;">
                    <span class="">2000</span>
                </div>
                <div onclick="addAmount(3000)" class="relative grid items-center font-sans font-bold uppercase whitespace-nowrap select-none border border-red-500 text-red-700 py-1.5 px-3 text-xs rounded-lg cursor-pointer" style="opacity: 1;">
                    <span class="">3000</span>
                </div>
                <div onclick="addAmount(5000)" class="relative grid items-center font-sans font-bold uppercase whitespace-nowrap select-none border border-red-500 text-red-700 py-1.5 px-3 text-xs rounded-lg cursor-pointer" style="opacity: 1;">
                    <span class="">5000</span>
                </div>
                <div onclick="addAmount(9000)" class="relative grid items-center font-sans font-bold uppercase whitespace-nowrap select-none border border-red-500 text-red-700 py-1.5 px-3 text-xs rounded-lg cursor-pointer" style="opacity: 1;">
                    <span class="">9000</span>
                </div>
                <div onclick="addAmount(15000)" class="relative grid items-center font-sans font-bold uppercase whitespace-nowrap select-none border border-red-500 text-red-700 py-1.5 px-3 text-xs rounded-lg cursor-pointer" style="opacity: 1;">
                    <span class="">15000</span>
                </div>
                <div onclick="addAmount(18000)" class="relative grid items-center font-sans font-bold uppercase whitespace-nowrap select-none border border-red-500 text-red-700 py-1.5 px-3 text-xs rounded-lg cursor-pointer" style="opacity: 1;">
                    <span class="">18000</span>
                </div>
                <div onclick="addAmount(25000)" class="relative grid items-center font-sans font-bold uppercase whitespace-nowrap select-none border border-red-500 text-red-700 py-1.5 px-3 text-xs rounded-lg cursor-pointer" style="opacity: 1;">
                    <span class="">25000</span>
                </div>
            </div>
        </div>

        <div class="m-5">
            <button type="submit"  id="submitBtn" class="align-middle select-none font-sans font-bold text-center uppercase transition-all disabled:opacity-50 disabled:shadow-none disabled:pointer-events-none text-xs py-3 px-6 text-white shadow-blue-500/20 hover:shadow-lg hover:shadow-blue-500/40 focus:opacity-[0.85] focus:shadow-none active:opacity-[0.85] active:shadow-none w-full hover:bg-[#F6BE00] mt-6 bg-[#F6BE00] shadow-none flex gap-3 justify-center items-center rounded-full">Next</button>
        </div>
    </form>




</div>





<script src="https://loan365.live/assets/front/js/jquery.min.js"></script>
<script src="https://loan365.live/assets/front/js/popper.min.js"></script>

<link rel="stylesheet" href="https://loan365.live/assets/front/css/iziToast.min.css">
<script src="https://loan365.live/assets/front/js/iziToast.min.js"></script>








<script src="https://loan365.live/assets/global/js/jquery-3.6.0.min.js"></script>
<script src="https://loan365.live/assets/global/js/bootstrap.bundle.min1.js"></script>
<script src="https://loan365.live/assets/templates/basic/js/vendor/lightcase.js"></script>
<script src="https://loan365.live/assets/templates/basic/js/vendor/jquery.nice-select.min.js"></script>
<script src="https://loan365.live/assets/templates/basic/js/vendor/slick.min.js"></script>
<script src="https://loan365.live/assets/templates/basic/js/vendor/wow.min.js"></script>
<script src="https://loan365.live/assets/templates/basic/js/app.js"></script>


<script>
    document.getElementById('submitBtn').addEventListener('click', function() {
        var amount = document.getElementById('amount').value;

        if (!amount) {  // Check if the amount field is empty
            showErrorToast();  // Show the error message
        }
    });

    function showErrorToast() {
        var toast = document.getElementById('errorToast');
        toast.style.display = 'block';  // Show the iziToast error message

        // Optional: Hide the toast after a few seconds (e.g., 3 seconds)
        setTimeout(function() {
            toast.style.display = 'none'; // Hide the toast after 3 seconds
        }, 3000);
    }

    function closeToast() {
        document.getElementById('errorToast').style.display = 'none';
    }



</script>

<script>
    function addAmount(amount) {
        $('#amount').val(amount);
    }





</script>

<script>
    function toggleElements() {
        // Get all payment method elements
        const paymentMethods = document.querySelectorAll('.deposit');

        paymentMethods.forEach(method => {
            // Remove selected class from all methods
            method.classList.remove('border-green-500');
            method.classList.add('border-red-300');

            // Add click event listener
            method.addEventListener('click', function() {
                // Remove selected class from all methods
                paymentMethods.forEach(m => {
                    m.classList.remove('border-green-500');
                    m.classList.add('border-red-300');
                });

                // Add selected class to clicked method
                this.classList.remove('border-red-300');
                this.classList.add('border-green-500');

                // Set the hidden input value
                const selectedId = this.getAttribute('data-id');
                document.getElementById('selected_payment_method').value = selectedId;
            });
        });
    }

    // Initialize on page load
    document.addEventListener('DOMContentLoaded', function() {
        toggleElements();
    });


    function addAmount(amount) {
        document.getElementById('amount').value = amount;
    }

</script>

    <link rel="stylesheet" href="https://loan365.live/assets/global/css/iziToast.min.css">

<script src="https://loan365.live/assets/global/js/iziToast.min.js"></script>

<script type="module" src="https://unpkg.com/ionicons@5.5.2/dist/ionicons/ionicons.js"></script>


<script>
    (function($, document) {
            "use strict";
            $(document).ready(function() {

                $('.deposit').on('click', function() {

                    $(".deposit").removeClass("border-green-600");
                    $(".deposit").addClass("border-gray-300");
                    // Add the "border-green-600" class to the clicked element
                    $(this).addClass("border-green-600");

                    var id = $(this).data('id');
                    var result = $(this).data('resource');
                    var baseSymbol = "Taka";
                    // var baseSymbol = $(this).data('base_symbol');

                    $('.method-name').text(`Payment By  ${result.name}`);
                    // $('.currency-addon').text(`${result.currency}`);
                    $('.currency-addon').text(baseSymbol);

                    $('.edit-currency').val(result.currency);
                    $('.edit-method-code').val(result.method_code);

                });
            });
        }
    )(jQuery, document);
</script>
<!-- Footer Navigation Start -->
<style>
  .footer {
    position: fixed;
    bottom: 0;
    width: 100%;
    background: rgba(15, 32, 39, 0.95);
    backdrop-filter: blur(4px);
    color: white;
    padding: 10px 0;
    box-shadow: 0 -4px 20px rgba(0, 0, 0, 0.4);
    z-index: 999;
    transition: background 0.3s ease;
  }
  .footer.scrolled {
    background: rgba(15, 32, 39, 0.8);
  }
  .footer .row {
    display: flex;
    justify-content: space-around;
    align-items: center;
    text-align: center;
    max-width: 1000px;
    margin: 0 auto;
    padding: 0 20px;
    flex-wrap: wrap;
  }
  .footer .col {
    flex: 1 1 25%;
    min-width: 70px;
    margin: 5px 0;
  }
  .footer .col a {
    display: flex;
    flex-direction: column;
    align-items: center;
    text-decoration: none;
    color: white;
    transition: transform 0.3s;
  }
  .footer .col a:hover {
    transform: scale(1.1);
  }
  .footer-icon {
    width: 48px;
    height: 48px;
    object-fit: contain;
    transition: all 0.3s ease-in-out;
    filter: drop-shadow(0 4px 8px rgba(0,0,0,0.4));
  }
  .footer p {
    margin: 4px 0 0;
    font-size: 14px;
  }
  .footer .col:nth-child(1) img {
    animation: float1 4s ease-in-out infinite;
    filter: drop-shadow(0 5px 12px rgba(255, 111, 0, 0.4));
  }
  .footer .col:nth-child(2) img {
    animation: float2 5s ease-in-out infinite;
    filter: drop-shadow(0 5px 12px rgba(37, 211, 102, 0.5));
  }
  .footer .col:nth-child(3) img {
    animation: float3 4.5s ease-in-out infinite;
    filter: drop-shadow(0 5px 12px rgba(255, 255, 0, 0.5));
  }
  .footer .col:nth-child(4) img {
    animation: float4 5.2s ease-in-out infinite;
    filter: drop-shadow(0 5px 12px rgba(0, 123, 255, 0.5));
  }
  @keyframes float1 {
    0% { transform: translateY(0px) rotateZ(0deg); }
    50% { transform: translateY(-4px) rotateZ(1deg); }
    100% { transform: translateY(0px) rotateZ(0deg); }
  }
  @keyframes float2 {
    0% { transform: translateY(0px) rotateZ(0deg); }
    50% { transform: translateY(-3px) rotateZ(-1deg); }
    100% { transform: translateY(0px) rotateZ(0deg); }
  }
  @keyframes float3 {
    0% { transform: translateY(0px) rotateZ(0deg); }
    50% { transform: translateY(-5px) rotateZ(1deg); }
    100% { transform: translateY(0px) rotateZ(0deg); }
  }
  @keyframes float4 {
    0% { transform: translateY(0px) rotateZ(0deg); }
    50% { transform: translateY(-3px) rotateZ(-1.5deg); }
    100% { transform: translateY(0px) rotateZ(0deg); }
  }
  @media (max-width: 768px) {
    .footer-icon {
      width: 38px;
      height: 38px;
    }
    .footer p {
      font-size: 12px;
    }
  }
  @media (max-width: 480px) {
    .footer .row {
      flex-direction: row;
      justify-content: space-between;
      padding: 0 10px;
    }
    .footer-icon {
      width: 32px;
      height: 32px;
    }
    .footer p {
      font-size: 11px;
    }
    .footer .col {
      flex: 1 1 22%;
    }
  }
</style>

<div class="footer" id="footer">
  <div class="row">
    <!-- Home -->
    <div class="col">
      <a href="/">
        <img class="footer-icon" src="/images/footer/home.png" alt="Home">
        <p>Home</p>
      </a>
    </div>
    <!-- WhatsApp -->
    <div class="col">
      <a href="https://wa.me/your-number" target="_blank">
        <img class="footer-icon" src="/images/footer/whatsapp.png" alt="WhatsApp">
        <p>WhatsApp</p>
      </a>
    </div>
    <!-- Profile -->
    <div class="col">
      <a href="profile.php">
        <img class="footer-icon" src="/images/footer/user-4.png" alt="Profile">
        <p>Profile</p>
      </a>
    </div>
    <!-- logout -->
    <div class="col">
      <a href="logout.php">
        <img class="footer-icon" src="/images/footer/logout-2.png" alt="logout">
        <p>logout</p>
      </a>
    </div>
  </div>
</div>

<script>
  const footer = document.getElementById('footer');
  window.addEventListener('scroll', () => {
    if (window.scrollY > 10) {
      footer.classList.add('scrolled');
    } else {
      footer.classList.remove('scrolled');
    }
  });
</script>
    <br>
<br>

<!-- Footer Navigation End -->


</body></html>