<?php
// Start session only once at the very beginning
if (session_status() == PHP_SESSION_NONE) {
}

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Database connection
header('Content-Type: text/html; charset=UTF-8');
$host = "localhost";
$user = "loannowl_loan1";
$pass = "loannowl_loan1";
$dbname = "loannowl_loan1";

$conn = new mysqli($host, $user, $pass, $dbname);

if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

$conn->set_charset("utf8mb4");

// Create necessary tables if they don't exist
$createTables = [
    "CREATE TABLE IF NOT EXISTS `settings` (
        `id` int(11) NOT NULL AUTO_INCREMENT,
        `logo` varchar(255) DEFAULT 'images/logo/logo4.png',
        `site_name` varchar(100) DEFAULT NULL,
        `contact_email` varchar(100) DEFAULT NULL,
        PRIMARY KEY (`id`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4",
    
    "CREATE TABLE IF NOT EXISTS `testimonials` (
        `id` int(11) NOT NULL AUTO_INCREMENT,
        `name` varchar(100) NOT NULL,
        `message` text NOT NULL,
        `date` datetime DEFAULT current_timestamp(),
        PRIMARY KEY (`id`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4"
];

foreach ($createTables as $sql) {
    if (!$conn->query($sql)) {
        die("Error creating table: " . $conn->error);
    }
}

// Insert default data if tables are empty
$checkSettings = $conn->query("SELECT COUNT(*) as count FROM `settings`");
if ($checkSettings && $checkSettings->fetch_assoc()['count'] == 0) {
    $conn->query("INSERT INTO `settings` (`logo`, `site_name`, `contact_email`) 
                 VALUES ('images/logo/logo4.png', 'Easy Loan', 'contact@example.com')");
}

$checkTestimonials = $conn->query("SELECT COUNT(*) as count FROM `testimonials`");
if ($checkTestimonials && $checkTestimonials->fetch_assoc()['count'] == 0) {
    $testimonialsData = [
        "INSERT INTO `testimonials` (`name`, `message`, `date`) VALUES 
        ('John Doe', 'Great service! Got my loan quickly.', '2023-01-15 10:30:00')",
        
        "INSERT INTO `testimonials` (`name`, `message`, `date`) VALUES 
        ('Jane Smith', 'Very helpful customer support.', '2023-02-20 11:45:00')",
        
        "INSERT INTO `testimonials` (`name`, `message`, `date`) VALUES 
        ('Robert Johnson', 'Simple process and fast approval.', '2023-03-10 09:15:00')"
    ];
    
    foreach ($testimonialsData as $sql) {
        $conn->query($sql);
    }
}

// Rest of your original code continues from here...
// Fetch WhatsApp number from database
$sql_whatsapp = "SELECT whatsapp FROM contact LIMIT 1";
$result_whatsapp = mysqli_query($conn, $sql_whatsapp);
$whatsapp_number = "";

if ($result_whatsapp && mysqli_num_rows($result_whatsapp) > 0) {
    $row = mysqli_fetch_assoc($result_whatsapp);
    $whatsapp_number = preg_replace('/[^0-9]/', '', $row['whatsapp']);
}

// ... [Rest of your original PHP code remains the same until the HTML starts]
?>