// স্বয়ংক্রিয় ভয়েস প্লেয়ার সিস্টেম
document.addEventListener('DOMContentLoaded', function() {
    // সকল প্রয়োজনীয় অডিও এলিমেন্ট তৈরি
    const audioElements = document.querySelectorAll('audio[data-auto-play]');
    
    audioElements.forEach(audio => {
        // গোপন স্টাইল প্রয়োগ
        audio.style.display = 'none';
        
        // স্বয়ংক্রিয় প্লে করার চেষ্টা
        const playPromise = audio.play();
        
        // যদি ব্রাউজার অটোপ্লে ব্লক করে
        if (playPromise !== undefined) {
            playPromise.catch(error => {
                // ব্যবহারকারী ইন্টারঅ্যাকশনের জন্য অপেক্ষা করুন
                const playOnInteraction = () => {
                    audio.play()
                        .then(() => {
                            window.removeEventListener('click', playOnInteraction);
                            window.removeEventListener('touchstart', playOnInteraction);
                        })
                        .catch(e => console.error('প্লে করতে ব্যর্থ:', e));
                };
                
                window.addEventListener('click', playOnInteraction, { once: true });
                window.addEventListener('touchstart', playOnInteraction, { once: true });
            });
        }
        
        // অডিও শেষ হলে ক্লিন আপ
        audio.addEventListener('ended', function() {
            audio.remove();
        });
    });
});