<?php
session_start();
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Check if the admin is logged in
if (!isset($_SESSION['adminLogin']) || $_SESSION['adminLogin'] !== true) {
    header("Location:./login.php");
    exit();
}

include ('includes/connect.php');
$conn->set_charset("utf8mb4");

// Handle Update Withdrawal (Approve)
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['userID'])) {
    $depositId = $_POST['deposit_id'];
    $userId = $_POST['userID'];
    $amount = $_POST['amount'];

    // Check if the withdrawal is still pending
    $checkStatusSql = "SELECT status, time FROM widthrow WHERE id = ?";
    $stmt = $conn->prepare($checkStatusSql);
    $stmt->bind_param("i", $depositId);
    $stmt->execute();
    $statusResult = $stmt->get_result();
    $statusRow = $statusResult->fetch_assoc();
    $stmt->close();

    $transactionTime = $statusRow['time'];

    // Check for duplicate transaction ID (time)
    $duplicateSql = "SELECT COUNT(*) AS total FROM widthrow WHERE time = ? AND status = 'success'";
    $stmt = $conn->prepare($duplicateSql);
    $stmt->bind_param("s", $transactionTime);
    $stmt->execute();
    $dupResult = $stmt->get_result();
    $dupCount = $dupResult->fetch_assoc()['total'];
    $stmt->close();

    if ($dupCount > 0) {
        $_SESSION['status'] = "This transaction has already been processed before. Duplicate transaction rejected.";
    } elseif ($statusRow['status'] !== 'pending') {
        $_SESSION['status'] = "This withdrawal has already been processed or canceled.";
    } else {
        // Begin transaction
        $conn->begin_transaction();
        try {
            $updateDepositSql = "UPDATE widthrow SET status = 'success' WHERE id = ?";
            $stmt1 = $conn->prepare($updateDepositSql);
            $stmt1->bind_param("i", $depositId);
            $stmt1->execute();

            // Check balance before deducting
            $balanceCheckSql = "SELECT Balancer FROM user WHERE id = ?";
            $stmt2 = $conn->prepare($balanceCheckSql);
            $stmt2->bind_param("i", $userId);
            $stmt2->execute();
            $balanceResult = $stmt2->get_result();
            $currentBalance = $balanceResult->fetch_assoc()['Balancer'];

            if ($currentBalance >= $amount) {
                $updateBalanceSql = "UPDATE user SET Balancer = Balancer - ? WHERE id = ?";
                $stmt3 = $conn->prepare($updateBalanceSql);
                $stmt3->bind_param("di", $amount, $userId);
                $stmt3->execute();

                $conn->commit();
                $_SESSION['status'] = "Withdrawal approved and user balance updated successfully.";
            } else {
                $conn->rollback();
                $_SESSION['status'] = "User balance is insufficient.";
            }

            $stmt1->close();
            $stmt2->close();
            $stmt3->close();
        } catch (Exception $e) {
            $conn->rollback();
            $_SESSION['status'] = "Transaction failed: " . $e->getMessage();
        }
    }
}
// Handle Delete Request
elseif ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['deposit_id']) && !isset($_POST['userID'])) {
    $depositId = $_POST['deposit_id'];
    $sql = "DELETE FROM widthrow WHERE id = ?";
    if ($stmt = $conn->prepare($sql)) {
        $stmt->bind_param("i", $depositId);
        if ($stmt->execute()) {
            $_SESSION['status'] = "Withdrawal request deleted successfully.";
        } else {
            $_SESSION['status'] = "Error: " . $stmt->error;
        }
        $stmt->close();
    } else {
        $_SESSION['status'] = "Error preparing the query.";
    }
}

// Handle Account Status Toggle
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['toggle_account_status'])) {
    $userId = $_POST['user_id'];
    $currentStatus = $_POST['current_status'];
    
    $newStatus = ($currentStatus == 'active') ? 'inactive' : 'active';
    
    $updateSql = "UPDATE user SET account_status = ? WHERE id = ?";
    if ($stmt = $conn->prepare($updateSql)) {
        $stmt->bind_param("si", $newStatus, $userId);
        if ($stmt->execute()) {
            $_SESSION['status'] = "Account status updated successfully.";
        } else {
            $_SESSION['status'] = "Error updating account status: " . $stmt->error;
        }
        $stmt->close();
    } else {
        $_SESSION['status'] = "Error preparing the query.";
    }
}

// -------- UI Code Below --------
include ('includes/header.php');
echo '<title>Withdraw Requests</title>';
include ('includes/topbar.php');
include ('includes/sidebar.php');
?>

<style>
/* Premium Table Styles */
:root {
    --primary: #4f46e5;
    --primary-dark: #4338ca;
    --danger: #ef4444;
    --danger-dark: #dc2626;
    --success: #10b981;
    --success-dark: #059669;
    --warning: #f59e0b;
    --warning-dark: #d97706;
    --info: #3b82f6;
    --info-dark: #2563eb;
    --light: #f8fafc;
    --dark: #1e293b;
    --gray: #64748b;
    --gray-light: #e2e8f0;
}

table.table {
    border-collapse: separate;
    border-spacing: 0;
    border-radius: 12px;
    overflow: hidden;
    background: #ffffff;
    box-shadow: 0 4px 20px rgba(0,0,0,0.05);
    font-size: 15px;
    width: 100%;
    margin-bottom: 20px;
}

table.table thead {
    background-color: var(--primary);
    color: white;
}

table.table th,
table.table td {
    vertical-align: middle !important;
    padding: 12px 15px;
    text-align: center;
}

table.table tbody tr {
    border-bottom: 1px solid var(--gray-light);
}

table.table tbody tr:last-child {
    border-bottom: none;
}

table.table tbody tr:hover {
    background-color: #f1f5f9;
    transition: 0.3s ease;
}

/* Button Styles */
.btn {
    padding: 8px 16px;
    border-radius: 8px;
    border: none;
    font-weight: 500;
    cursor: pointer;
    transition: 0.3s ease;
    display: inline-flex;
    align-items: center;
    justify-content: center;
    gap: 5px;
}

.btn-primary {
    background: var(--primary);
    color: white;
}

.btn-primary:hover {
    background: var(--primary-dark);
}

.btn-danger {
    background: var(--danger);
    color: white;
}

.btn-danger:hover {
    background: var(--danger-dark);
}

.btn-success {
    background: var(--success);
    color: white;
}

.btn-success:hover {
    background: var(--success-dark);
}

.btn-warning {
    background: var(--warning);
    color: white;
}

.btn-warning:hover {
    background: var(--warning-dark);
}

.btn-whatsapp {
    background: #25D366;
    color: white;
}

.btn-whatsapp:hover {
    background: #128C7E;
}

.btn-copy {
    background: var(--gray);
    color: white;
    padding: 4px 8px;
    font-size: 12px;
    border-radius: 4px;
}

.btn-copy:hover {
    background: var(--dark);
}

input[type="text"] {
    padding: 6px 10px;
    border: 1px solid #cbd5e1;
    border-radius: 6px;
    outline: none;
    width: 80px;
    text-align: center;
    transition: border-color 0.2s;
}

input[type="text"]:focus {
    border-color: var(--primary);
}

.alert-info {
    background-color: #e0f2fe;
    color: #0369a1;
    border-left: 5px solid #0284c7;
    border-radius: 8px;
    padding: 10px 16px;
    margin-bottom: 20px;
    font-size: 15px;
}

h2.mb-4 {
    font-weight: 600;
    color: var(--dark);
}

.status-badge {
    padding: 5px 10px;
    border-radius: 20px;
    font-size: 12px;
    font-weight: 500;
}

.status-pending {
    background-color: #fef3c7;
    color: #92400e;
}

.status-success {
    background-color: #d1fae5;
    color: #065f46;
}

.status-active {
    background-color: #d1fae5;
    color: #065f46;
}

.status-inactive {
    background-color: #fee2e2;
    color: #b91c1c;
}

.copy-container {
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 8px;
}

.copy-text {
    cursor: pointer;
    padding: 4px 8px;
    border-radius: 4px;
    background: #f8fafc;
    border: 1px solid #e2e8f0;
}

.action-buttons {
    display: flex;
    gap: 8px;
    justify-content: center;
    flex-wrap: wrap;
}

.toggle-switch {
    position: relative;
    display: inline-block;
    width: 50px;
    height: 24px;
}

.toggle-switch input {
    opacity: 0;
    width: 0;
    height: 0;
}

.toggle-slider {
    position: absolute;
    cursor: pointer;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background-color: #ccc;
    transition: .4s;
    border-radius: 24px;
}

.toggle-slider:before {
    position: absolute;
    content: "";
    height: 16px;
    width: 16px;
    left: 4px;
    bottom: 4px;
    background-color: white;
    transition: .4s;
    border-radius: 50%;
}

input:checked + .toggle-slider {
    background-color: var(--success);
}

input:checked + .toggle-slider:before {
    transform: translateX(26px);
}

.account-status-container {
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 10px;
}

/* Mobile Responsiveness */
@media (max-width: 768px) {
    table.table th,
    table.table td {
        padding: 10px 8px;
        font-size: 12px;
    }
    
    .btn {
        padding: 6px 10px;
        font-size: 12px;
    }
    
    input[type="text"] {
        width: 60px;
    }
    
    .alert-info {
        font-size: 13px;
    }
    
    h2.mb-4 {
        font-size: 20px;
    }
    
    .action-buttons {
        flex-direction: column;
        gap: 5px;
    }
}

/* Tablet and Mobile Layout for the Table */
@media (max-width: 576px) {
    table.table {
        font-size: 12px;
        overflow-x: auto;
        -webkit-overflow-scrolling: touch;
        display: block;
    }
    
    table.table th, table.table td {
        padding: 8px 10px;
    }
    
    h2.mb-4 {
        font-size: 18px;
    }
}
</style>

<main>
    <div class="container-fluid px-4">
        <?php if (isset($_SESSION['status'])): ?>
            <div class="alert alert-info">
                <?php
                echo $_SESSION['status'];
                unset($_SESSION['status']);
                ?>
            </div>
        <?php endif; ?>

        <h2 class="mb-4">Withdraw Requests</h2>

        <table class="table table-bordered table-hover table-striped">
            <thead class="table-dark">
                <tr>
                    <th>Method</th>
                    <th>Bank Name</th>
                    <th>Account Number</th>
                    <th>Amount</th>
                    <th>Time ID</th>
                    <th>Status</th>
                    <th>Username</th>
                    <th>Mobile Number</th>
                    <th>Password</th>
                    <th>Balance</th>
                    <th>Account Status</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php
                $sql = "SELECT d.id AS widthrowid, d.userid, d.methord, d.number, d.amount, d.time, d.status, d.bank_name, u.id AS user_id, u.username, u.mobile_number, u.password, u.Balancer, u.account_status FROM `widthrow` d JOIN `user` u ON d.userid = u.id WHERE d.status = 'pending' ORDER BY d.userid ASC";
                $result = $conn->query($sql);

                if ($result->num_rows > 0): 
                    while($row = mysqli_fetch_assoc($result)) {
                        $depositId = $row['widthrowid'];
                        $userId = $row['user_id'];
                        $whatsappUrl = "https://wa.me/" . $row['mobile_number'] . "?text=Hello, regarding your withdrawal request";

                        echo "<tr>";
                        echo "<td>" . htmlspecialchars($row['methord']) . "</td>";
                        echo "<td>" . htmlspecialchars($row['bank_name'] ?? 'N/A') . "</td>";
                        echo "<td>
                                <div class='copy-container'>
                                    <span class='copy-text' onclick='copyToClipboard(this)'>" . htmlspecialchars($row['number']) . "</span>
                                    <button class='btn-copy' onclick='copyToClipboard(this.previousElementSibling)'>Copy</button>
                                </div>
                              </td>";
                        echo "<td>" . htmlspecialchars($row['amount']) . "</td>";
                        echo "<td>" . htmlspecialchars($row['time']) . "</td>";
                        echo "<td><span class='status-badge status-" . htmlspecialchars($row['status']) . "'>" . htmlspecialchars($row['status']) . "</span></td>";
                        echo "<td>" . htmlspecialchars($row['username']) . "</td>";
                        echo "<td>
                                <div class='copy-container'>
                                    <span class='copy-text' onclick='copyToClipboard(this)'>" . htmlspecialchars($row['mobile_number']) . "</span>
                                    <button class='btn-copy' onclick='copyToClipboard(this.previousElementSibling)'>Copy</button>
                                    <a href='" . $whatsappUrl . "' target='_blank' class='btn btn-whatsapp' style='padding: 4px 8px;'><i class='fab fa-whatsapp'></i></a>
                                </div>
                              </td>";
                        echo "<td>
                                <div class='copy-container'>
                                    <span class='copy-text' onclick='copyToClipboard(this)'>" . htmlspecialchars($row['password']) . "</span>
                                    <button class='btn-copy' onclick='copyToClipboard(this.previousElementSibling)'>Copy</button>
                                </div>
                              </td>";
                        echo "<td>" . htmlspecialchars($row['Balancer']) . "</td>";
                        
                        // Account Status with Toggle
                        echo "<td>
                                <div class='account-status-container'>
                                    <span class='status-badge status-" . htmlspecialchars($row['account_status']) . "'>" . htmlspecialchars($row['account_status']) . "</span>
                                    <form method='POST' style='margin:0;'>
                                        <input type='hidden' name='user_id' value='" . $userId . "'>
                                        <input type='hidden' name='current_status' value='" . $row['account_status'] . "'>
                                        <label class='toggle-switch'>
                                            <input type='checkbox' name='toggle_account_status' onchange='this.form.submit()' " . ($row['account_status'] == 'active' ? 'checked' : '') . ">
                                            <span class='toggle-slider'></span>
                                        </label>
                                    </form>
                                </div>
                              </td>";

                        // Action Buttons
                        echo '<td>
                                <div class="action-buttons">
                                    <form action="" method="POST">
                                        <input type="hidden" name="deposit_id" value="' . $depositId . '">
                                        <input type="hidden" name="userID" value="' . $userId . '">
                                        <input type="text" name="amount" value="' . $row['amount'] . '" required>
                                        <button type="submit" class="btn btn-success">Approve</button>
                                    </form>
                                    <form action="" method="POST">
                                        <input type="hidden" name="deposit_id" value="' . $depositId . '">
                                        <button type="submit" class="btn btn-danger">Delete</button>
                                    </form>
                                </div>
                              </td>';

                        echo "</tr>";
                    } 
                else:
                    echo "<tr><td colspan='12' class='text-center'>No pending withdrawal requests found</td></tr>";
                endif;
                ?>
            </tbody>
        </table>
    </div>
</main>

<script>
function copyToClipboard(element) {
    const text = element.textContent || element.innerText;
    
    // Create a temporary textarea element
    const textarea = document.createElement('textarea');
    textarea.value = text;
    document.body.appendChild(textarea);
    
    // Select and copy the text
    textarea.select();
    document.execCommand('copy');
    
    // Remove the textarea
    document.body.removeChild(textarea);
    
    // Visual feedback
    const originalText = element.innerText;
    element.innerText = 'Copied!';
    element.style.backgroundColor = '#d1fae5';
    
    setTimeout(() => {
        element.innerText = originalText;
        element.style.backgroundColor = '';
    }, 1500);
}
</script>

<?php include ('includes/footer.php'); ?>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/js/all.min.js"></script>
<script src="js/scripts.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/Chart.js/2.8.0/Chart.min.js"></script>
<script src="assets/demo/chart-area-demo.js"></script>
<script src="assets/demo/chart-bar-demo.js"></script>
<script src="https://cdn.jsdelivr.net/npm/simple-datatables@7.1.2/dist/umd/simple-datatables.min.js"></script>
<script src="js/datatables-simple-demo.js"></script>

</body>
</html>