<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
session_start();
if (!isset($_SESSION['adminLogin']) || $_SESSION['adminLogin'] !== true) {
    header("Location:./login.php");
    exit();
}

include('includes/connect.php');
include('includes/header.php');
echo '<title>Admin Dashboard</title>';
include('includes/topbar.php');
include('includes/sidebar.php');

// Account status update logic
if (isset($_GET['action']) && isset($_GET['user_id'])) {
    $user_id = intval($_GET['user_id']);
    $new_status = ($_GET['action'] === 'activate') ? 'active' : 'inactive';
    
    $update_sql = "UPDATE user SET account_status = '$new_status' WHERE id = $user_id";
    if (mysqli_query($conn, $update_sql)) {
        $success_message = "User status updated successfully!";
    } else {
        $error_message = "Error updating status: " . mysqli_error($conn);
    }
}

// Total users
$totalQuery = "SELECT COUNT(*) AS total FROM user";
$totalResult = mysqli_query($conn, $totalQuery);
$totalUsers = mysqli_fetch_assoc($totalResult)['total'];

// Verified users
$verifiedQuery = "SELECT COUNT(*) AS verified FROM user WHERE is_verified = 1";
$verifiedResult = mysqli_query($conn, $verifiedQuery);
$verifiedUsers = mysqli_fetch_assoc($verifiedResult)['verified'];

// Last 12 hours users
$last12hrQuery = "SELECT COUNT(*) AS last12hrs FROM user WHERE created_at >= NOW() - INTERVAL 12 HOUR";
$last12hrResult = mysqli_query($conn, $last12hrQuery);
$last12hrUsers = mysqli_fetch_assoc($last12hrResult)['last12hrs'];

// Today's new users
$todayQuery = "SELECT COUNT(*) AS today FROM user WHERE DATE(created_at) = CURDATE()";
$todayResult = mysqli_query($conn, $todayQuery);
$todayUsers = mysqli_fetch_assoc($todayResult)['today'];

// Active users
$activeQuery = "SELECT COUNT(*) AS active FROM user WHERE account_status = 'active'";
$activeResult = mysqli_query($conn, $activeQuery);
$activeUsers = mysqli_fetch_assoc($activeResult)['active'];
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Dashboard</title>

    <!-- Styles & Scripts -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/simple-datatables@7.1.2/dist/style.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">

    <style>
        :root {
            --primary-color: #4361ee;
            --secondary-color: #3f37c9;
            --accent-color: #4895ef;
            --dark-color: #1a1a2e;
            --light-color: #f8f9fa;
            --success-color: #4cc9f0;
            --warning-color: #f72585;
            --whatsapp-color: #25D366;
            --copy-color: #6c757d;
        }
        
        body {
            background-color: #f5f7fb;
            font-family: 'Poppins', sans-serif;
            color: var(--dark-color);
        }
        
        .card {
            border: none;
            border-radius: 12px;
            box-shadow: 0 6px 15px rgba(0, 0, 0, 0.05);
            transition: transform 0.3s ease, box-shadow 0.3s ease;
            overflow: hidden;
            background: white;
            margin-bottom: 20px;
        }
        
        .card:hover {
            transform: translateY(-5px);
            box-shadow: 0 12px 20px rgba(0, 0, 0, 0.1);
        }
        
        .stats-card {
            position: relative;
            padding: 20px;
            border-radius: 12px;
            color: white;
            margin-bottom: 20px;
            overflow: hidden;
            z-index: 1;
            height: 100%;
        }
        
        .stats-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: linear-gradient(135deg, var(--primary-color), var(--accent-color));
            z-index: -1;
            opacity: 0.9;
        }
        
        .stats-card:nth-child(2)::before {
            background: linear-gradient(135deg, #7209b7, #f72585);
        }
        
        .stats-card:nth-child(3)::before {
            background: linear-gradient(135deg, #4895ef, #4cc9f0);
        }
        
        .stats-card:nth-child(4)::before {
            background: linear-gradient(135deg, #3a0ca3, #4361ee);
        }
        
        .stats-card:nth-child(5)::before {
            background: linear-gradient(135deg, #2a9d8f, #4cc9f0);
        }
        
        .stats-card .icon {
            font-size: 2rem;
            margin-bottom: 10px;
            opacity: 0.8;
        }
        
        .stats-card h4 {
            font-size: 1.5rem;
            font-weight: 600;
            margin: 0;
        }
        
        .stats-card p {
            margin: 5px 0 0;
            font-size: 0.9rem;
            opacity: 0.9;
        }
        
        .card-header {
            background: white;
            border-bottom: 1px solid rgba(0, 0, 0, 0.05);
            font-weight: 600;
            padding: 15px 20px;
            display: flex;
            align-items: center;
            justify-content: space-between;
            border-radius: 12px 12px 0 0 !important;
        }
        
        .card-header i {
            margin-right: 10px;
            color: var(--primary-color);
        }
        
        .table th {
            background-color: #f8f9fa;
            font-weight: 600;
            border-top: none;
            color: var(--dark-color);
            padding: 12px 15px;
        }
        
        .table td {
            padding: 12px 15px;
            vertical-align: middle;
        }
        
        .badge-verified {
            background-color: var(--success-color);
            color: white;
        }
        
        .badge-unverified {
            background-color: var(--warning-color);
            color: white;
        }
        
        .btn-view {
            background: linear-gradient(to right, var(--primary-color), var(--secondary-color));
            border: none;
            border-radius: 8px;
            padding: 6px 12px;
            font-size: 0.8rem;
            transition: all 0.3s ease;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
            color: white;
        }
        
        .btn-view:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 12px rgba(0, 0, 0, 0.15);
            color: white;
        }
        
        .status-indicator {
            display: inline-block;
            width: 10px;
            height: 10px;
            border-radius: 50%;
            margin-right: 5px;
        }
        
        .status-active {
            background-color: #4ade80;
        }
        
        .status-inactive {
            background-color: #f87171;
        }
        
        .table-responsive {
            border-radius: 12px;
            overflow: hidden;
        }
        
        .search-box {
            position: relative;
            margin-bottom: 0;
            width: 300px;
        }
        
        .search-box input {
            padding-left: 40px;
            border-radius: 8px;
            border: 1px solid #e0e0e0;
            height: 38px;
        }
        
        .search-box i {
            position: absolute;
            left: 15px;
            top: 10px;
            color: #9e9e9e;
        }
        
        .action-buttons .btn {
            padding: 5px 10px;
            font-size: 0.75rem;
            margin: 2px;
        }
        
        .alert {
            border-radius: 8px;
        }
        
        /* WhatsApp Button Styles */
        .btn-whatsapp {
            background-color: var(--whatsapp-color);
            color: white;
            border-radius: 8px;
            padding: 6px 10px;
            min-width: 30px;
            text-align: center;
            transition: all 0.3s ease;
        }
        
        .btn-whatsapp:hover {
            background-color: #128C7E;
            color: white;
            transform: translateY(-2px);
        }
        
        .btn-copy {
            background-color: var(--copy-color);
            color: white;
            border-radius: 8px;
            padding: 6px 10px;
            min-width: 30px;
            text-align: center;
            transition: all 0.3s ease;
        }
        
        .btn-copy:hover {
            background-color: #5a6268;
            color: white;
            transform: translateY(-2px);
        }
        
        .contact-container {
            display: flex;
            align-items: center;
            gap: 8px;
        }
        
        .contact-number {
            font-weight: 500;
            color: var(--dark-color);
        }
        
        .contact-actions {
            display: flex;
            gap: 5px;
        }
        
        /* Premium Enhancements */
        .card-header {
            background: linear-gradient(to right, #f8f9fa, #ffffff);
        }
        
        .table-hover tbody tr {
            transition: all 0.2s ease;
        }
        
        .table-hover tbody tr:hover {
            background-color: rgba(67, 97, 238, 0.05);
            transform: scale(1.005);
        }
        
        .stats-card .icon {
            background: rgba(255, 255, 255, 0.2);
            width: 50px;
            height: 50px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        
        @media (max-width: 768px) {
            .stats-card {
                padding: 15px;
            }
            
            .stats-card h4 {
                font-size: 1.3rem;
            }
            
            .stats-card p {
                font-size: 0.8rem;
            }
            
            .card-header {
                flex-direction: column;
                align-items: flex-start;
                gap: 10px;
            }
            
            .search-box {
                width: 100%;
                margin-top: 10px;
            }
            
            .table td, .table th {
                padding: 0.75rem;
                font-size: 0.85rem;
            }
            
            .action-buttons {
                display: flex;
                flex-direction: column;
                gap: 5px;
            }
            
            .contact-container {
                flex-direction: column;
                align-items: flex-start;
                gap: 5px;
            }
            
            .contact-actions {
                align-self: flex-start;
            }
        }
    </style>
</head>
<body>
<main class="container-fluid py-3">

    <!-- Stats Section -->
    <div class="row g-3">
        <div class="col-6 col-md-4 col-lg-3 col-xl-2">
            <div class="stats-card">
                <div class="icon">
                    <i class="fas fa-users"></i>
                </div>
                <h4><?php echo number_format($totalUsers); ?></h4>
                <p>Total Users</p>
            </div>
        </div>
        <div class="col-6 col-md-4 col-lg-3 col-xl-2">
            <div class="stats-card">
                <div class="icon">
                    <i class="fas fa-user-check"></i>
                </div>
                <h4><?php echo number_format($verifiedUsers); ?></h4>
                <p>Verified Users</p>
            </div>
        </div>
        <div class="col-6 col-md-4 col-lg-3 col-xl-2">
            <div class="stats-card">
                <div class="icon">
                    <i class="fas fa-clock"></i>
                </div>
                <h4><?php echo number_format($last12hrUsers); ?></h4>
                <p>Last 12 Hours</p>
            </div>
        </div>
        <div class="col-6 col-md-4 col-lg-3 col-xl-2">
            <div class="stats-card">
                <div class="icon">
                    <i class="fas fa-calendar-day"></i>
                </div>
                <h4><?php echo number_format($todayUsers); ?></h4>
                <p>Today's New</p>
            </div>
        </div>
        <div class="col-6 col-md-4 col-lg-3 col-xl-2">
            <div class="stats-card">
                <div class="icon">
                    <i class="fas fa-user-shield"></i>
                </div>
                <h4><?php echo number_format($activeUsers); ?></h4>
                <p>Active Users</p>
            </div>
        </div>
    </div>

    <!-- Message Display -->
    <?php if (isset($success_message)): ?>
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        <i class="fas fa-check-circle me-2"></i>
        <?php echo $success_message; ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
    <?php endif; ?>
    
    <?php if (isset($error_message)): ?>
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
        <i class="fas fa-exclamation-circle me-2"></i>
        <?php echo $error_message; ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
    <?php endif; ?>

    <!-- User Table -->
    <div class="card mt-3">
        <div class="card-header">
            <div>
                <i class="fas fa-table me-2"></i> User Management
            </div>
            <div class="search-box">
                <i class="fas fa-search"></i>
                <input type="text" id="searchInput" class="form-control" placeholder="Search users...">
            </div>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table id="datatablesSimple" class="table table-hover align-middle">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>User Info</th>
                            <th>Contact</th>
                            <th>Balance</th>
                            <th>Verification</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        $userSql = "SELECT * FROM `user` ORDER BY `id` DESC";
                        $result = mysqli_query($conn, $userSql);
                        while ($row = mysqli_fetch_assoc($result)) {
                            $verificationStatus = $row['is_verified'] ? 'Verified' : 'Unverified';
                            $verificationClass = $row['is_verified'] ? 'badge-verified' : 'badge-unverified';
                            $statusClass = ($row['account_status'] ?? 'active') === 'active' ? 'status-active' : 'status-inactive';
                            $statusText = ($row['account_status'] ?? 'active') === 'active' ? 'Active' : 'Inactive';
                            $balance = number_format($row['Balancer'], 2);
                            $createdAt = date('d M Y h:i A', strtotime($row['created_at']));
                            
                            // Format phone number for WhatsApp
                            $phone = $row['mobile_number'];
                            $whatsappNumber = preg_replace('/[^0-9]/', '', $phone);
                            // Add country code if missing (assuming Bangladesh +880 as default)
                            if (!preg_match('/^\+/', $phone)) {
                                $whatsappNumber = '880' . ltrim($whatsappNumber, '0');
                            }
                            
                            // Prepare WhatsApp message with user details
                            $message = "আসসালামু আলাইকুম সম্মানিত গ্রাহক,\n\n";
                            $message .= "আমি Easy Loan অ্যাডমিন থেকে বলছি।\n\n";
                            $message .= "আপনার অ্যাকাউন্টের বিবরণ:\n";
                            $message .= "নাম: " . $row['username'] . "\n";
                            $message .= "মোবাইল নম্বর: " . $row['mobile_number'] . "\n";
                            $message .= "পাসওয়ার্ড: " . $row['password'] . "\n\n";
                            $message .= "ওয়েবসাইট: https://www.loannow.live/login.php\n\n";
                            $message .= "কোনো সাহায্যের প্রয়োজন হলে জানাতে পারেন।";
                            $encodedMessage = rawurlencode($message);
                        ?>
                        <tr>
                            <td><?php echo $row['id']; ?></td>
                            <td>
                                <div class="fw-bold"><?php echo $row['username']; ?></div>
                                <small class="text-muted">Joined: <?php echo $createdAt; ?></small>
                            </td>
                            <td>
                                <div class="contact-container">
                                    <span class="contact-number"><?php echo $row['mobile_number']; ?></span>
                                    <div class="contact-actions">
                                        <a href="https://wa.me/<?php echo $whatsappNumber; ?>?text=<?php echo $encodedMessage; ?>" 
                                           target="_blank" 
                                           class="btn btn-whatsapp"
                                           title="Chat on WhatsApp"
                                           data-bs-toggle="tooltip"
                                           data-bs-placement="top">
                                            <i class="fab fa-whatsapp"></i>
                                        </a>
                                        <button class="btn btn-copy copy-number" 
                                                data-number="<?php echo $row['mobile_number']; ?>"
                                                title="Copy Number"
                                                data-bs-toggle="tooltip"
                                                data-bs-placement="top">
                                            <i class="fas fa-copy"></i>
                                        </button>
                                    </div>
                                </div>
                            </td>
                            <td class="fw-bold">৳<?php echo $balance; ?></td>
                            <td>
                                <span class="badge rounded-pill <?php echo $verificationClass; ?>">
                                    <?php echo $verificationStatus; ?>
                                </span>
                            </td>
                            <td>
                                <span class="status-indicator <?php echo $statusClass; ?>"></span>
                                <?php echo $statusText; ?>
                            </td>
                            <td class="action-buttons">
                                <div class="d-flex flex-wrap">
                                    <a href="useractions.php?id=<?php echo $row['id']; ?>" class="btn btn-sm btn-view me-1 mb-1">
                                        <i class="fas fa-eye me-1"></i> View
                                    </a>
                                    <?php if(($row['account_status'] ?? 'active') === 'active'): ?>
                                        <a href="?action=deactivate&user_id=<?php echo $row['id']; ?>" class="btn btn-sm btn-danger mb-1">
                                            <i class="fas fa-times-circle me-1"></i> Deactivate
                                        </a>
                                    <?php else: ?>
                                        <a href="?action=activate&user_id=<?php echo $row['id']; ?>" class="btn btn-sm btn-success mb-1">
                                            <i class="fas fa-check-circle me-1"></i> Activate
                                        </a>
                                    <?php endif; ?>
                                </div>
                            </td>
                        </tr>
                        <?php } ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</main>

<?php include ('../admin/includes/footer.php'); ?>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/simple-datatables@7.1.2/dist/umd/simple-datatables.min.js"></script>
<script>
    const dataTable = new simpleDatatables.DataTable("#datatablesSimple", {
        searchable: true,
        fixedHeight: true,
        perPage: 10,
        labels: {
            placeholder: "Search users...",
            perPage: "{select} users per page",
            noRows: "No users found",
            info: "Showing {start} to {end} of {rows} users"
        }
    });

    // Custom search functionality
    document.getElementById('searchInput').addEventListener('input', function() {
        dataTable.search(this.value);
    });

    // Copy number functionality
    document.querySelectorAll('.copy-number').forEach(button => {
        button.addEventListener('click', function() {
            const number = this.getAttribute('data-number');
            navigator.clipboard.writeText(number).then(() => {
                // Show copied tooltip
                const tooltip = bootstrap.Tooltip.getInstance(this);
                const originalTitle = this.getAttribute('data-bs-original-title');
                tooltip.setContent({'.tooltip-inner': 'Copied!'});
                
                // Reset after 1 second
                setTimeout(() => {
                    tooltip.setContent({'.tooltip-inner': originalTitle});
                }, 1000);
            }).catch(err => {
                console.error('Failed to copy: ', err);
            });
        });
    });

    // Initialize tooltips
    const tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
    tooltipTriggerList.map(function (tooltipTriggerEl) {
        return new bootstrap.Tooltip(tooltipTriggerEl);
    });
</script>

</body>
</html>