<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

include('includes/connect.php');
include('includes/header.php');
echo '<title>Admin Dashboard</title>';
include('includes/topbar.php');
include('includes/sidebar.php');

// ---------- INSERT FORM SUBMISSION ----------
$success = '';
$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = trim($_POST['name']);
    $message = trim($_POST['message']);

    if (!empty($name) && !empty($message)) {
        // Check if the columns exist in your table
        $stmt = $conn->prepare("INSERT INTO testimonials (name, message) VALUES (?, ?)");
        $stmt->bind_param("ss", $name, $message);
        
        if ($stmt->execute()) {
            $success = "Testimonial added successfully!";
            // Refresh the page to show the new testimonial
            echo "<script>window.location.href = window.location.href;</script>";
            exit();
        } else {
            $error = "Failed to add testimonial: " . $conn->error;
        }
        $stmt->close();
    } else {
        $error = "Name and Message are required.";
    }
}

// ---------- FETCH TESTIMONIALS ----------
$testimonials = [];
$sql = "SELECT * FROM testimonials ORDER BY id DESC";
$result = $conn->query($sql);
if ($result) {
    while ($row = $result->fetch_assoc()) {
        $testimonials[] = $row;
    }
} else {
    $error = "Error fetching testimonials: " . $conn->error;
}
?>

<div class="container mt-5 mb-4">
    <div class="card shadow p-4">
        <h4 class="mb-3">Add New Testimonial</h4>
        <?php if (!empty($success)): ?>
            <div class="alert alert-success"><?= $success ?></div>
        <?php elseif (!empty($error)): ?>
            <div class="alert alert-danger"><?= htmlspecialchars($error) ?></div>
        <?php endif; ?>
        <form method="POST">
            <div class="mb-3">
                <label class="form-label">Customer Name</label>
                <input type="text" name="name" class="form-control" required />
            </div>
            <div class="mb-3">
                <label class="form-label">Review Message</label>
                <textarea name="message" class="form-control" rows="4" required></textarea>
            </div>
            <button type="submit" class="btn btn-primary">Add Testimonial</button>
        </form>
    </div>
</div>

<div class="container mb-5">
    <div class="row justify-content-center">
        <div class="col-12" style="background: #f9f9f9; border-radius: 15px; box-shadow: 0 4px 8px rgba(0,0,0,0.1); border: 1px solid #ddd;">
            <h4 class="text-center fw-bold py-3 border-bottom">Customer Reviews</h4>
            <p class="text-center text-muted mb-3">Total Testimonials: <strong><?= count($testimonials) ?></strong></p>

            <?php if (count($testimonials) > 0): ?>
            <div id="testimonialCarousel" class="carousel slide" data-bs-ride="carousel">
                <div class="carousel-inner">
                    <?php
                    $active = true;
                    foreach ($testimonials as $row):
                        $imgHtml = '<div class="bg-primary text-white rounded-circle d-flex justify-content-center align-items-center me-3" style="width: 50px; height: 50px; font-size: 24px;"><i class="bi bi-person-fill"></i></div>';
                    ?>
                    <div class="carousel-item <?= $active ? 'active' : '' ?>">
                        <div class="card border-0 shadow-sm rounded-3 p-3">
                            <p class="text-muted"><?= htmlspecialchars($row['message']) ?></p>
                            <div class="d-flex align-items-center mt-3">
                                <?= $imgHtml ?>
                                <div>
                                    <h6 class="mb-0"><?= htmlspecialchars($row['name']) ?></h6>
                                    <small class="text-muted"><?= htmlspecialchars(date("Y-m-d", strtotime($row['date']))) ?></small>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php
                    $active = false;
                    endforeach;
                    ?>
                </div>
                <button class="carousel-control-prev" type="button" data-bs-target="#testimonialCarousel" data-bs-slide="prev">
                    <span class="carousel-control-prev-icon bg-dark rounded-circle" style="width: 25px; height: 25px;"></span>
                    <span class="visually-hidden">Previous</span>
                </button>
                <button class="carousel-control-next" type="button" data-bs-target="#testimonialCarousel" data-bs-slide="next">
                    <span class="carousel-control-next-icon bg-dark rounded-circle" style="width: 25px; height: 25px;"></span>
                    <span class="visually-hidden">Next</span>
                </button>
            </div>
            <?php else: ?>
                <div class="alert alert-info">No testimonials found.</div>
            <?php endif; ?>
        </div>
    </div>
</div>

<!-- Table for managing -->
<div class="container mb-5">
    <div class="card p-4 shadow-sm">
        <h5 class="mb-3">Manage Testimonials</h5>
        <?php if (!empty($error)): ?>
            <div class="alert alert-danger"><?= htmlspecialchars($error) ?></div>
        <?php endif; ?>
        <table class="table table-bordered table-hover">
            <thead class="table-light">
                <tr>
                    <th>#</th>
                    <th>Name</th>
                    <th>Message</th>
                    <th>Date</th>
                    <th style="width: 120px;">Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php if (count($testimonials) > 0): ?>
                    <?php foreach ($testimonials as $index => $row): ?>
                    <tr>
                        <td><?= $index + 1 ?></td>
                        <td><?= htmlspecialchars($row['name']) ?></td>
                        <td><?= htmlspecialchars($row['message']) ?></td>
                        <td><?= htmlspecialchars(date("Y-m-d", strtotime($row['date']))) ?></td>
                        <td>
                            <a href="edit_testimonial.php?id=<?= $row['id'] ?>" class="btn btn-sm btn-warning">Edit</a>
                            <a href="delete_testimonial.php?id=<?= $row['id'] ?>" onclick="return confirm('Are you sure you want to delete this testimonial?');" class="btn btn-sm btn-danger">Delete</a>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="5" class="text-center">No testimonials found</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>

<!-- Bootstrap & Icons -->
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>