<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
session_start();

// Check if the admin is logged in
if (!isset($_SESSION['adminLogin']) || $_SESSION['adminLogin'] !== true) {
    header("Location:../login.php");
    exit();
}


if ($_SERVER["REQUEST_METHOD"] == "POST") {

    $amount = $_POST['amount'];
    $currentBalance = $_POST['currentbalance'];
    $messageType = $_POST['messageType'];
    $number = $_POST['number'];

    // Generate transaction ID and current date-time
    $transactionId = strtoupper(uniqid('TXN-')); // Unique transaction ID with "TXN-" prefix
    $currentDateTime = date("Y-m-d H:i:s"); // Format: YYYY-MM-DD HH:MM:SS

    // Define messages based on type
    switch ($messageType) {
        case "receiveAmount":
            $message = "RBC Bank: You have received $amount. Your new balance is $currentBalance. Transaction ID: $transactionId. Date: $currentDateTime.";
            break;
        case "sendAmount":
            $message = "RBC Bank: You have sent $amount. Your remaining balance is $currentBalance. Transaction ID: $transactionId. Date: $currentDateTime.";
            break;
        case "withdrawalConfirmation":
            $message = "RBC Bank: Your withdrawal of $amount was successful. Balance: $currentBalance. Transaction ID: $transactionId. Date: $currentDateTime.";
            break;
        case "loadApproval":
            $message = "RBC Bank: Your load request of $amount has been approved. Transaction ID: $transactionId. Date: $currentDateTime.";
            break;
        case "generalLoadConfirmation":
            $message = "RBC Bank: Funds of $amount have been loaded to your account. New balance: $currentBalance. Transaction ID: $transactionId. Date: $currentDateTime.";
            break;
        default:
            $message = "Invalid message type.";
    }

    echo $message;

    include ('../sendmassages.php');
    sendMessage($number, $message);





}
include ('../includes/connect.php');


include ('../admin/includes/header.php');
echo '<title>Dashboard Admin</title>';
include ('../admin/includes/topbar.php');
include ('../admin/includes/sidebar.php');





?>


<main>
    <div class="container-fluid px-4">
        <h1 class="mt-4">Send Massage</h1>
        <ol class="breadcrumb mb-4">

        </ol>


        <form action="massagelist.php" method="post" enctype="multipart/form-data">
            <label for="number">Number With County code:</label>
            <input name="number" type="text" required>


            <label for="amount">Amount:</label>
            <input name="amount" type="number" required>

            <label for="currentbalance">Current Balance:</label>
            <input name="currentbalance" type="number" required>




            <label for="messageType">Select Message Type:</label>
            <select name="messageType" required>
                <option value="receiveAmount">Receive Amount</option>
                <option value="sendAmount">Send Amount</option>
                <option value="withdrawalConfirmation">Withdrawal Confirmation</option>
                <option value="loadApproval">Load Approval</option>
                <option value="generalLoadConfirmation">General Load Confirmation</option>
            </select>

            <button type="submit">Send Message</button>
        </form>








    </div>
</main>




<?php

include ('../admin/includes/footer.php');


?>


<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/js/bootstrap.bundle.min.js" crossorigin="anonymous"></script>
<script src="js/scripts.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/Chart.js/2.8.0/Chart.min.js" crossorigin="anonymous"></script>
<script src="assets/demo/chart-area-demo.js"></script>
<script src="assets/demo/chart-bar-demo.js"></script>
<script src="https://cdn.jsdelivr.net/npm/simple-datatables@7.1.2/dist/umd/simple-datatables.min.js" crossorigin="anonymous"></script>
<script src="js/datatables-simple-demo.js"></script>
</body>
</html>
