<?php
session_start();
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Check if the admin is logged in
if (!isset($_SESSION['adminLogin']) || $_SESSION['adminLogin'] !== true) {
    header("Location:../login.php");
    exit();
}

include ('../includes/connect.php');


include ('../admin/includes/header.php');
echo '<title>Dashboard Admin</title>';
include ('../admin/includes/topbar.php');
include ('../admin/includes/sidebar.php');





?>


<main>
    <div class="container-fluid px-4">
        <h1 class="mt-4">Loan Request</h1>
        <ol class="breadcrumb mb-4">
            <li class="breadcrumb-item active">Loan Request</li>
        </ol>







        <div class="card mb-4">
            <div class="card-header">
                <i class="fas fa-table me-1"></i>

               Loan Requests

            </div>

            <div class="card-body">
                <table id="datatablesSimple">
                    <thead>
                    <tr>
                        <th>ID</th>
                        <th>User ID</th>
                        <th>Loan Amount</th>
                        <th>Loan Purpose</th>
                        <th>Gender</th>
                        <th>Monthly Income</th>
                        <th>First Name</th>
                        <th>Dependents</th>
                        <th>Email</th>
                        <th>Phone</th>
                        <th>Marital Status</th>
                        <th>City</th>
                        <th>Street</th>
                        <th>House Number</th>
                        <th>Homeowner Status</th>
                        <th>Employment Industry</th>
                        <th>Employer Name</th>
                        <th>Work Phone</th>
                        <th>Status</th>
                        <th>Actions</th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php
                    $userSql = "SELECT * FROM `applications` ORDER BY `applications`.`id` ASC";
                    $result = mysqli_query($conn, $userSql);

                    while ($row = mysqli_fetch_assoc($result)) {
                        ?>
                        <tr>
                            <td><?php echo htmlspecialchars($row['id']); ?></td>
                            <td><?php echo htmlspecialchars($row['user_id']); ?></td>
                            <td><?php echo htmlspecialchars($row['loan_amount']); ?></td>
                            <td><?php echo htmlspecialchars($row['loan_purpose']); ?></td>
                            <td><?php echo htmlspecialchars($row['gender']); ?></td>
                            <td><?php echo htmlspecialchars($row['monthly_income']); ?></td>
                            <td><?php echo htmlspecialchars($row['first_name']); ?></td>
                            <td><?php echo htmlspecialchars($row['dependents']); ?></td>
                            <td><?php echo htmlspecialchars($row['email']); ?></td>
                            <td><?php echo htmlspecialchars($row['phone']); ?></td>
                            <td><?php echo htmlspecialchars($row['marital_status']); ?></td>
                            <td><?php echo htmlspecialchars($row['city']); ?></td>
                            <td><?php echo htmlspecialchars($row['street']); ?></td>
                            <td><?php echo htmlspecialchars($row['house_number']); ?></td>
                            <td><?php echo htmlspecialchars($row['homeowner_status']); ?></td>
                            <td><?php echo htmlspecialchars($row['employment_industry']); ?></td>
                            <td><?php echo htmlspecialchars($row['employer_name']); ?></td>
                            <td><?php echo htmlspecialchars($row['work_phone']); ?></td>
                            <td><?php echo htmlspecialchars($row['status']); ?></td>
                            <td>
                                <form action="loanAprovPages.php" method="get">
                                    <input name="id" type="hidden" value="<?php echo $row['id'] ?>">
                                    <button type="submit" class="btn btn-success">Visit Actions</button>
                                </form>
                            </td>
                        </tr>
                        <?php
                    }
                    ?>
                    </tbody>
                </table>
            </div>

        </div>
    </div>
</main>




<?php

include ('../admin/includes/footer.php');


?>


<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/js/bootstrap.bundle.min.js" crossorigin="anonymous"></script>
<script src="js/scripts.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/Chart.js/2.8.0/Chart.min.js" crossorigin="anonymous"></script>
<script src="assets/demo/chart-area-demo.js"></script>
<script src="assets/demo/chart-bar-demo.js"></script>
<script src="https://cdn.jsdelivr.net/npm/simple-datatables@7.1.2/dist/umd/simple-datatables.min.js" crossorigin="anonymous"></script>
<script src="js/datatables-simple-demo.js"></script>
</body>
</html>
