<?php
session_start();
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Check if the admin is logged in
if (!isset($_SESSION['adminLogin']) || $_SESSION['adminLogin'] !== true) {
    header("Location:../login.php");
    exit();
}





include ('../includes/connect.php');


if ($_SERVER["REQUEST_METHOD"] == "POST") {

    $loanid=$_POST["uid"];
    $actions=$_POST["actions"];
    $loan_amount=$_POST["loan_amount"];

    $sql = "SELECT * FROM `applications` WHERE `id` = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $loanid);
    $stmt->execute();
    $result = $stmt->get_result();

    $appyed = $result->fetch_assoc();

    $usderid=$appyed['user_id'];

    if ($actions=="approved"){

        $updateuserBalance="UPDATE `users` SET `initial_deposit` = `initial_deposit`+$loan_amount WHERE `users`.`id` = '$usderid'";
        $update=mysqli_query($conn,$updateuserBalance);
        $sql="UPDATE `applications` SET `status` = '$actions' WHERE `applications`.`id` = '$loanid'";
        mysqli_query($conn,$sql);
        include ('../history.php');
        $currentDateTime = date('Y-m-d H:i:s');
        saveTransaction($usderid, "Loan Approved", $loan_amount, $currentDateTime, "Your Loan Granted", "RBC Royal Bank");
        $_SESSION['status']="loanApproved";



    }else{
        $sql="UPDATE `applications` SET `status` = '$actions' WHERE `applications`.`id` = '$loanid'";
        mysqli_query($conn,$sql);
        include ('../history.php');
        $currentDateTime = date('Y-m-d H:i:s');
        saveTransaction($usderid, "Loan ".$actions, $loan_amount, $currentDateTime, "Your Loan ".$actions, "RBC Royal Bank");
        $_SESSION['status']=$actions;
    }

    header("Location:loanAprovPages.php?id=".$loanid);
    exit();


}
include ('../admin/includes/header.php');
echo '<title>Dashboard Admin</title>';
include ('../admin/includes/topbar.php');
include ('../admin/includes/sidebar.php');





?>


<main>
    <div class="container-fluid px-4">
        <h1 class="mt-4">Loan Request</h1>
        <ol class="breadcrumb mb-4">
            <li class="breadcrumb-item active">Loan Request</li>
        </ol>



        <div class="alert alert-info">
            <?php
            if (isset($_SESSION['status'])) {
                echo $_SESSION['status'];
                unset($_SESSION['status']);
            }

            ?>
        </div>



        <div class="card mb-4">
            <div class="card-header">
                <i class="fas fa-table me-1"></i>

               Loan Process Pages

            </div>







                <form action="loanAprovPages.php" method="post" class="p-4 border rounded bg-light">
                    <input name="uid" type="hidden" value="<?php echo $_GET['id']?>">
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <label for="loan_amount" class="form-label">Loan Amount ($)</label>
                            <input type="number" id="loan_amount" value="00" name="loan_amount" class="form-control" placeholder="Enter amount" required>
                        </div>
                    </div>

                    <div class="row mb-3">
                        <!-- Purpose of Loan -->
                        <div class="col-md-6">
                            <label for="actions" class="form-label">Purpose of Loan</label>
                            <select id="loan_purpose" name="actions" class="form-select" required>
                                <option value="approved">approved</option>
                                <option value="rejected">rejected</option>
                                <option value="cancelled">cancelled</option>

                            </select>
                        </div>
                        </div>


                    <div class="col-md-6">

                        <button type="submit"  class="form-control" >Submit</button>
                    </div>



            </form>



        </div>
    </div>
</main>




<?php

include ('../admin/includes/footer.php');


?>


<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/js/bootstrap.bundle.min.js" crossorigin="anonymous"></script>
<script src="js/scripts.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/Chart.js/2.8.0/Chart.min.js" crossorigin="anonymous"></script>
<script src="assets/demo/chart-area-demo.js"></script>
<script src="assets/demo/chart-bar-demo.js"></script>
<script src="https://cdn.jsdelivr.net/npm/simple-datatables@7.1.2/dist/umd/simple-datatables.min.js" crossorigin="anonymous"></script>
<script src="js/datatables-simple-demo.js"></script>
</body>
</html>
