<?php
session_start();
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

if (!isset($_SESSION['adminLogin']) || $_SESSION['adminLogin'] !== true) {
    header("Location: ./login.php");
    exit();
}

include('includes/connect.php');

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $id = isset($_POST['id']) ? intval($_POST['id']) : 0;
    $amount = isset($_POST['amount']) ? floatval($_POST['amount']) : null;

    if ($id <= 0) {
        $_SESSION['status'] = "Invalid ID";
        header("Location: loanApplyed.php");
        exit();
    }

    if (isset($_POST['action']) && $_POST['action'] === 'delete') {
        $deleteQuery = "DELETE FROM loan_applications WHERE id = $id";
        if (mysqli_query($conn, $deleteQuery)) {
            $_SESSION['status'] = "Loan deleted successfully.";
        } else {
            $_SESSION['status'] = "Delete failed: " . mysqli_error($conn);
        }
    } elseif ($amount !== null) {
        $uid = isset($_POST['uid']) ? intval($_POST['uid']) : 0;
        $updateQuery = "UPDATE user SET `Balancer` = `Balancer` + $amount WHERE id = $uid";
        $approve = "UPDATE `loan_applications` SET `status` = 'approved' WHERE `id` = $id";
        $result = mysqli_query($conn, $approve);

        if ($result) {
            if (mysqli_query($conn, $updateQuery)) {
                $_SESSION['status'] = "Balance updated for loan ID: " . $id;
            } else {
                $_SESSION['status'] = "Balance update failed: " . mysqli_error($conn);
            }
        } else {
            $_SESSION['status'] = "Approve failed: " . mysqli_error($conn);
        }
    }

    // 🔁 REDIRECT to prevent resubmission on refresh
    header("Location: loanApplyed.php");
    exit();
}

include('includes/header.php');
echo '<title>Premium Loan Management System</title>';
include('includes/topbar.php');
include('includes/sidebar.php');
?>

<!-- Toast Notification -->
<?php if (isset($_SESSION['status'])): ?>
    <div class="position-fixed top-0 end-0 p-3" style="z-index: 1080;">
        <div class="toast align-items-center text-white bg-success border-0 shadow show" role="alert">
            <div class="d-flex">
                <div class="toast-body"><?= htmlspecialchars($_SESSION['status']) ?></div>
                <button type="button" class="btn-close btn-close-white me-2 m-auto" data-bs-dismiss="toast"></button>
            </div>
        </div>
    </div>
    <?php unset($_SESSION['status']); ?>
<?php endif; ?>

<!-- Delete Modal -->
<div class="modal fade" id="deleteModal" tabindex="-1" aria-labelledby="deleteModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content border-0 shadow-lg">
      <div class="modal-header bg-danger text-white">
        <h5 class="modal-title">Confirm Deletion</h5>
        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
      </div>
      <form method="post" action="loanApplyed.php">
        <input type="hidden" name="id" id="deleteId">
        <input type="hidden" name="action" value="delete">
        <div class="modal-body">
          Are you sure you want to delete this loan application?
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
          <button type="submit" class="btn btn-danger">Confirm Delete</button>
        </div>
      </form>
    </div>
  </div>
</div>

<!-- Add Balance Modal -->
<div class="modal fade" id="addBalanceModal" tabindex="-1">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content border-0 shadow-lg">
      <div class="modal-header bg-success text-white">
        <h5 class="modal-title">Add Balance</h5>
        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
      </div>
      <form method="post" action="loanApplyed.php">
        <input type="hidden" name="id" id="balanceLoanId">
        <input type="hidden" name="uid" id="balanceUserId">
        <div class="modal-body">
          <div class="mb-3">
            <label class="form-label">Enter Amount</label>
            <input type="number" class="form-control" name="amount" id="balanceAmount" required>
          </div>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
          <button type="submit" class="btn btn-success">Add Balance</button>
        </div>
      </form>
    </div>
  </div>
</div>

<!-- WhatsApp Message Modal -->
<div class="modal fade" id="whatsappModal" tabindex="-1">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content border-0 shadow-lg">
      <div class="modal-header bg-info text-white">
        <h5 class="modal-title">Send WhatsApp Message</h5>
        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body">
        <div class="mb-3">
          <label class="form-label">Recipient Number</label>
          <input type="text" class="form-control" id="whatsappNumber" readonly>
        </div>
        <div class="mb-3">
          <label class="form-label">Message Template</label>
          <textarea class="form-control" id="whatsappMessage" rows="4">Hello! Your loan application has been processed. Thank you for choosing our service.</textarea>
        </div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
        <a id="whatsappLink" class="btn btn-success" target="_blank">
          <i class="fab fa-whatsapp me-2"></i>Send via WhatsApp
        </a>
      </div>
    </div>
  </div>
</div>

<main>
  <div class="container-fluid px-3">
    <div class="mt-4 mb-4">
      <h1 class="text-primary fw-bold">Premium Loan Management</h1>
      <p class="text-muted">Manage loan applications and user details in real-time</p>
    </div>

    <div class="card shadow border-0 premium-card">
      <div class="card-header bg-primary text-white py-3">
        <div class="d-flex justify-content-between align-items-center">
          <h5 class="mb-0"><i class="fas fa-file-invoice-dollar me-2"></i>Loan Applications</h5>
          <span class="badge bg-light text-primary">Real-time Data</span>
        </div>
      </div>
      <div class="card-body p-4">
        <div class="table-responsive">
          <table class="table table-hover align-middle" id="loanTable">
            <thead class="table-light">
              <tr>
                <th>Loan Details</th>
                <th>User Information</th>
                <th>Balance & Status</th>
                <th class="text-center">Actions</th>
              </tr>
            </thead>
            <tbody>
            <?php
            $sql = "SELECT l.id AS loan_id, l.loan_name, l.amount, l.duration, l.advance,
                    l.application_date, l.status, u.id AS user_id, u.username, u.mobile_number, 
                    u.password, u.Balancer, u.created_at, u.account_status, u.is_verified 
                    FROM loan_applications l 
                    JOIN user u ON l.user_id = u.id 
                    WHERE l.status = 'pending'
                    ORDER BY l.id DESC";
            $result = $conn->query($sql);

            if ($result->num_rows > 0):
                while($row = $result->fetch_assoc()): 
                $statusClass = $row['status'] == 'approved' ? 'bg-success' : ($row['status'] == 'rejected' ? 'bg-danger' : 'bg-warning');
                $verifiedIcon = $row['is_verified'] ? '<i class="fas fa-check-circle text-success" title="Verified"></i>' : '<i class="fas fa-times-circle text-danger" title="Not Verified"></i>';
                $accountStatus = $row['account_status'] == 'active' ? 'text-success' : 'text-danger';
                ?>
                <tr>
                  <td>
                    <div class="d-flex flex-column">
                      <div class="fw-semibold text-primary mb-1"><?= htmlspecialchars($row['loan_name']) ?></div>
                      <div class="d-flex flex-wrap gap-3">
                        <div>
                          <small class="text-muted">Amount:</small>
                          <div class="fw-bold">$<?= number_format($row['amount'], 2) ?></div>
                        </div>
                        <div>
                          <small class="text-muted">Duration:</small>
                          <div><?= $row['duration'] ?> months</div>
                        </div>
                        <div>
                          <small class="text-muted">Advance:</small>
                          <div>$<?= number_format($row['advance'], 2) ?></div>
                        </div>
                      </div>
                      <small class="text-muted mt-1">Applied: <?= date('M j, Y, g:i a', strtotime($row['application_date'])) ?></small>
                    </div>
                  </td>
                  <td>
                    <div class="d-flex flex-column">
                      <div class="d-flex align-items-center mb-1">
                        <span class="fw-medium me-2"><?= $row['username'] ?></span>
                        <button class="btn btn-sm btn-outline-primary py-0 copy-btn" data-text="<?= $row['username'] ?>" title="Copy username">
                          <i class="fas fa-copy fa-xs"></i>
                        </button>
                      </div>
                      <div class="d-flex align-items-center mb-1">
                        <span class="me-2">ID: <?= $row['user_id'] ?></span>
                        <span class="badge <?= $accountStatus ?>"><?= $row['account_status'] ?></span>
                        <?= $verifiedIcon ?>
                      </div>
                      <div class="d-flex align-items-center mb-1">
                        <span class="me-2"><?= $row['mobile_number'] ?></span>
                        <button class="btn btn-sm btn-outline-primary py-0 copy-btn me-1" data-text="<?= $row['mobile_number'] ?>" title="Copy mobile">
                          <i class="fas fa-copy fa-xs"></i>
                        </button>
                        <button class="btn btn-sm btn-outline-success py-0 whatsapp-btn" data-number="<?= $row['mobile_number'] ?>" title="Send WhatsApp message">
                          <i class="fab fa-whatsapp fa-xs"></i>
                        </button>
                      </div>
                      <div class="d-flex align-items-center">
                        <span class="text-truncate me-2" style="max-width: 100px;"><?= $row['password'] ?></span>
                        <button class="btn btn-sm btn-outline-primary py-0 copy-btn" data-text="<?= $row['password'] ?>" title="Copy password">
                          <i class="fas fa-copy fa-xs"></i>
                        </button>
                      </div>
                      <small class="text-muted mt-1">Joined: <?= date('M j, Y', strtotime($row['created_at'])) ?></small>
                    </div>
                  </td>
                  <td>
                    <div class="d-flex flex-column">
                      <div class="mb-2">
                        <small class="text-muted">Current Balance:</small>
                        <div class="fw-bold fs-5 text-success">$<?= number_format($row['Balancer'], 2) ?></div>
                      </div>
                      <div>
                        <small class="text-muted">Loan Status:</small>
                        <div><span class="badge <?= $statusClass ?>"><?= $row['status'] ?></span></div>
                      </div>
                    </div>
                  </td>
                  <td>
                    <div class="d-flex flex-column gap-2">
                      <button class="btn btn-danger btn-action" onclick="confirmDelete(<?= $row['loan_id'] ?>)">
                        <i class="fas fa-trash-alt me-1"></i> Delete
                      </button>
                      <button class="btn btn-success btn-action" onclick="openAddBalanceModal(<?= $row['loan_id'] ?>, <?= $row['user_id'] ?>, <?= $row['amount'] ?>)">
                        <i class="fas fa-plus-circle me-1"></i> Add Balance
                      </button>
                    </div>
                  </td>
                </tr>
            <?php endwhile;
            else: ?>
              <tr>
                <td colspan="4" class="text-center py-5">
                  <div class="py-4">
                    <i class="fas fa-folder-open fa-2x text-muted mb-3"></i>
                    <p class="text-muted">No pending loan applications found.</p>
                  </div>
                </td>
              </tr>
            <?php endif; ?>
            </tbody>
          </table>
        </div>
      </div>
    </div>
  </div>
</main>

<?php include('includes/footer.php'); ?>

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

<script>
function confirmDelete(id) {
    document.getElementById('deleteId').value = id;
    var myModal = new bootstrap.Modal(document.getElementById('deleteModal'));
    myModal.show();
}

function openAddBalanceModal(loanId, userId, amount) {
    document.getElementById('balanceLoanId').value = loanId;
    document.getElementById('balanceUserId').value = userId;
    document.getElementById('balanceAmount').value = amount;
    var modal = new bootstrap.Modal(document.getElementById('addBalanceModal'));
    modal.show();
}

function openWhatsAppModal(number) {
    document.getElementById('whatsappNumber').value = number;
    
    // Create WhatsApp link
    const message = encodeURIComponent(document.getElementById('whatsappMessage').value);
    const whatsappUrl = `https://wa.me/${number}?text=${message}`;
    document.getElementById('whatsappLink').href = whatsappUrl;
    
    var modal = new bootstrap.Modal(document.getElementById('whatsappModal'));
    modal.show();
}

document.addEventListener('DOMContentLoaded', function () {
    // Initialize toast notifications
    var toastElList = [].slice.call(document.querySelectorAll('.toast'));
    toastElList.map(function (toastEl) {
        var toast = new bootstrap.Toast(toastEl, { delay: 4000 });
        toast.show();
    });
    
    // Copy functionality
    const copyButtons = document.querySelectorAll('.copy-btn');
    copyButtons.forEach(button => {
        button.addEventListener('click', function() {
            const textToCopy = this.getAttribute('data-text');
            navigator.clipboard.writeText(textToCopy).then(() => {
                // Show temporary feedback
                const originalHtml = this.innerHTML;
                this.innerHTML = '<i class="fas fa-check fa-xs"></i>';
                this.classList.remove('btn-outline-primary');
                this.classList.add('btn-success');
                
                setTimeout(() => {
                    this.innerHTML = originalHtml;
                    this.classList.remove('btn-success');
                    this.classList.add('btn-outline-primary');
                }, 1500);
            });
        });
    });
    
    // WhatsApp functionality
    const whatsappButtons = document.querySelectorAll('.whatsapp-btn');
    whatsappButtons.forEach(button => {
        button.addEventListener('click', function() {
            const number = this.getAttribute('data-number');
            openWhatsAppModal(number);
        });
    });
    
    // Update WhatsApp link when message changes
    document.getElementById('whatsappMessage').addEventListener('input', function() {
        const number = document.getElementById('whatsappNumber').value;
        const message = encodeURIComponent(this.value);
        const whatsappUrl = `https://wa.me/${number}?text=${message}`;
        document.getElementById('whatsappLink').href = whatsappUrl;
    });
});
</script>

<style>
@import url('https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap');

:root {
  --primary: #4361ee;
  --secondary: #6c757d;
  --success: #198754;
  --info: #0dcaf0;
  --warning: #ffc107;
  --danger: #dc3545;
  --light: #f8f9fa;
  --dark: #212529;
  --bg-gradient: linear-gradient(120deg, #fdfbfb 0%, #ebedee 100%);
  --premium-gradient: linear-gradient(135deg, #4361ee 0%, #3a0ca3 100%);
  --card-shadow: 0 10px 30px rgba(0, 0, 0, 0.08);
}

body {
  font-family: 'Poppins', sans-serif;
  background-color: #f5f7fb;
  color: #495057;
}

.premium-card {
  border-radius: 16px;
  overflow: hidden;
  box-shadow: var(--card-shadow);
  border: none;
}

.card-header {
  border-bottom: 1px solid rgba(255, 255, 255, 0.15);
}

.table {
  margin-bottom: 0;
  border-collapse: separate;
  border-spacing: 0;
}

.table thead th {
  background-color: #f1f5f9;
  border-bottom: 2px solid #e9ecef;
  font-weight: 600;
  color: #495057;
  padding: 1rem 0.75rem;
}

.table tbody td {
  padding: 1.25rem 0.75rem;
  vertical-align: top;
  border-bottom: 1px solid #edf2f7;
}

.table-hover tbody tr:hover {
  background-color: rgba(67, 97, 238, 0.05);
  transform: translateY(-2px);
  transition: all 0.2s ease;
  box-shadow: 0 4px 12px rgba(0, 0, 0, 0.05);
}

.btn-action {
  border-radius: 8px;
  font-weight: 500;
  padding: 0.5rem 1rem;
  transition: all 0.2s ease;
  width: 100%;
}

.btn-action:hover {
  transform: translateY(-2px);
  box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
}

.btn-sm {
  padding: 0.25rem 0.5rem;
  font-size: 0.875rem;
}

.btn-success {
  background-color: var(--success);
  border-color: var(--success);
}

.btn-success:hover {
  background-color: #0f6848;
  border-color: #0f6848;
}

.badge {
  font-weight: 500;
  padding: 0.5em 0.75em;
  border-radius: 6px;
}

.copy-btn, .whatsapp-btn {
  border-radius: 6px;
  padding: 0.2rem 0.4rem;
}

.toast {
  border-radius: 8px;
}

.modal-content {
  border-radius: 16px;
  box-shadow: 0 20px 40px rgba(0, 0, 0, 0.15);
}

/* Responsive adjustments */
@media (max-width: 1200px) {
  .table-responsive {
    overflow-x: auto;
  }
}

@media (max-width: 992px) {
  .table thead {
    display: none;
  }
  
  .table tbody tr {
    display: block;
    margin-bottom: 1.5rem;
    border-radius: 12px;
    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.08);
    overflow: hidden;
  }
  
  .table tbody td {
    display: block;
    text-align: right;
    padding: 1rem;
    position: relative;
    padding-left: 50%;
    border-bottom: 1px solid #edf2f7;
  }
  
  .table tbody td:before {
    content: attr(data-label);
    position: absolute;
    left: 1rem;
    width: 45%;
    padding-right: 1rem;
    text-align: left;
    font-weight: 600;
    color: #495057;
  }
  
  .table tbody td:last-child {
    border-bottom: 0;
  }
  
  .btn-action {
    width: auto;
    margin: 0.25rem;
  }
  
  .toast {
    top: 70px !important;
    right: 10px !important;
    max-width: 300px;
  }
}

@media (max-width: 768px) {
  .table tbody td {
    padding-left: 40%;
  }
  
  .table tbody td:before {
    width: 35%;
  }
  
  .card-body {
    padding: 1rem;
  }
}

@media (max-width: 576px) {
  .table tbody td {
    padding-left: 1rem;
    text-align: left;
  }
  
  .table tbody td:before {
    position: relative;
    left: 0;
    width: 100%;
    margin-bottom: 0.5rem;
    display: block;
  }
  
  .d-flex.flex-wrap {
    flex-direction: column;
    gap: 0.5rem !important;
  }
}
</style>

<script>
// Add data-label attributes for responsive table
document.addEventListener('DOMContentLoaded', function() {
  const headers = ['Loan Details', 'User Information', 'Balance & Status', 'Actions'];
  const rows = document.querySelectorAll('#loanTable tbody tr');
  
  rows.forEach(row => {
    const cells = row.querySelectorAll('td');
    cells.forEach((cell, index) => {
      cell.setAttribute('data-label', headers[index]);
    });
  });
});
</script>