<?php
session_start();
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

if (!isset($_SESSION['adminLogin']) || $_SESSION['adminLogin'] !== true) {
    header("Location:./login.php");
    exit();
}

include('includes/connect.php');
include('includes/header.php');
echo '<title>Admin Dashboard</title>';
include('includes/topbar.php');
include('includes/sidebar.php');
?>

<style>
    body {
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        background: #f7f9fc;
    }

    .card {
        border: none;
        border-radius: 16px;
        transition: all 0.4s ease-in-out;
        box-shadow: 0 8px 20px rgba(0, 0, 0, 0.08);
        text-align: center;
    }

    .card:hover {
        transform: translateY(-5px);
        box-shadow: 0 12px 24px rgba(0, 0, 0, 0.15);
    }

    .bg-gradient-primary {
        background: linear-gradient(135deg, #4e54c8, #8f94fb);
        color: #ffffff;
    }

    .bg-gradient-success {
        background: linear-gradient(135deg, #00b09b, #96c93d);
        color: #ffffff;
    }

    .bg-gradient-danger {
        background: linear-gradient(135deg, #f85032, #e73827);
        color: #ffffff;
    }

    .bg-gradient-warning {
        background: linear-gradient(135deg, #f7971e, #ffd200);
        color: #ffffff;
    }

    .bg-gradient-info {
        background: linear-gradient(135deg, #36d1dc, #5b86e5);
        color: #ffffff;
    }

    .bg-gradient-secondary {
        background: linear-gradient(135deg, #9796f0, #fbc7d4);
        color: #ffffff;
    }

    .card-footer a,
    .card-footer i {
        color: #ffffff !important;
    }

    .breadcrumb {
        background: transparent;
        font-weight: 500;
    }

    #notification-panel {
        position: fixed;
        top: 80px;
        right: 20px;
        background: white;
        border-radius: 12px;
        box-shadow: 0 5px 15px rgba(0,0,0,0.2);
        width: 300px;
        z-index: 9999;
        display: none;
        overflow: hidden;
    }

    #notification-panel .message {
        padding: 12px 16px;
        border-bottom: 1px solid #eee;
        font-size: 15px;
        color: #333;
    }

    #notification-panel .close-btn {
        position: absolute;
        top: 8px;
        right: 12px;
        font-size: 18px;
        color: #888;
        cursor: pointer;
    }

    @media (max-width: 576px) {
        #notification-panel {
            width: 90%;
            right: 5%;
        }

        .card-body i {
            font-size: 1.8rem !important;
        }

        .card-body h5 {
            font-size: 1rem !important;
        }
    }
</style>

<!-- Font Awesome -->
<script src="https://kit.fontawesome.com/a076d05399.js" crossorigin="anonymous"></script>

<main>
    <div class="container py-5">
        <h1 class="mt-4 text-center">Dashboard</h1>
        <ol class="breadcrumb mb-4 justify-content-center">
            <li class="breadcrumb-item active">Dashboard</li>
        </ol>

        <div class="row g-4 justify-content-center">
            <!-- Loan Settings -->
            <div class="col-xl-3 col-md-6 col-12 mb-4">
                <div class="card bg-gradient-primary text-white">
                    <div class="card-body py-4">
                        <i class="fas fa-cogs fa-2x mb-2"></i>
                        <h5 class="mt-2">Loan Settings</h5>
                    </div>
                    <div class="card-footer d-flex align-items-center justify-content-between">
                        <a class="text-white stretched-link" href="loanAdd.php">View Details</a>
                        <i class="fas fa-angle-right"></i>
                    </div>
                </div>
            </div>

            <!-- Loan Applications -->
            <div class="col-xl-3 col-md-6 col-12 mb-4">
                <div class="card bg-gradient-success text-white">
                    <div class="card-body py-4">
                        <i class="fas fa-file-signature fa-2x mb-2"></i>
                        <h5 class="mt-2">Loan Applications</h5>
                    </div>
                    <div class="card-footer d-flex align-items-center justify-content-between">
                        <a class="text-white stretched-link" href="loanApplyed.php">View Details</a>
                        <i class="fas fa-angle-right"></i>
                    </div>
                </div>
            </div>

            <!-- Add Links -->
            <div class="col-xl-3 col-md-6 col-12 mb-4">
                <div class="card bg-gradient-danger text-white">
                    <div class="card-body py-4">
                        <i class="fas fa-link fa-2x mb-2"></i>
                        <h5 class="mt-2">Add Links</h5>
                    </div>
                    <div class="card-footer d-flex align-items-center justify-content-between">
                        <a class="text-white stretched-link" href="addLinks.php">View Details</a>
                        <i class="fas fa-angle-right"></i>
                    </div>
                </div>
            </div>

            <!-- Payment Number -->
            <div class="col-xl-3 col-md-6 col-12 mb-4">
                <div class="card bg-gradient-success text-white">
                    <div class="card-body py-4">
                        <i class="fas fa-money-bill-wave fa-2x mb-2"></i>
                        <h5 class="mt-2">Payment Number</h5>
                    </div>
                    <div class="card-footer d-flex align-items-center justify-content-between">
                        <a class="text-white stretched-link" href="payment_crud.php">View Details</a>
                        <i class="fas fa-angle-right"></i>
                    </div>
                </div>
            </div>

            <!-- Customer Reviews -->
            <div class="col-xl-3 col-md-6 col-12 mb-4">
                <div class="card bg-gradient-success text-white">
                    <div class="card-body py-4">
                        <i class="fas fa-comment-dots fa-2x mb-2"></i>
                        <h5 class="mt-2">Customer Reviews</h5>
                    </div>
                    <div class="card-footer d-flex align-items-center justify-content-between">
                        <a class="text-white stretched-link" href="testimonial_system.php">View Details</a>
                        <i class="fas fa-angle-right"></i>
                    </div>
                </div>
            </div>

            <!-- Deposit Requests -->
            <div class="col-xl-3 col-md-6 col-12 mb-4">
                <div class="card bg-gradient-warning text-white">
                    <div class="card-body py-4">
                        <i class="fas fa-university fa-2x mb-2"></i>
                        <h5 class="mt-2">Deposit Requests</h5>
                    </div>
                    <div class="card-footer d-flex align-items-center justify-content-between">
                        <a class="text-white stretched-link" href="depositerequst.php">View Details</a>
                        <i class="fas fa-angle-right"></i>
                    </div>
                </div>
            </div>

            <!-- Withdraw Requests -->
            <div class="col-xl-3 col-md-6 col-12 mb-4">
                <div class="card bg-gradient-info text-white">
                    <div class="card-body py-4">
                        <i class="fas fa-hand-holding-usd fa-2x mb-2"></i>
                        <h5 class="mt-2">Withdraw Requests</h5>
                    </div>
                    <div class="card-footer d-flex align-items-center justify-content-between">
                        <a class="text-white stretched-link" href="widthrowrequst.php">View Details</a>
                        <i class="fas fa-angle-right"></i>
                    </div>
                </div>
            </div>

            <!-- User List -->
            <div class="col-xl-3 col-md-6 col-12 mb-4">
                <div class="card bg-gradient-secondary text-white">
                    <div class="card-body py-4">
                        <i class="fas fa-users fa-2x mb-2"></i>
                        <h5 class="mt-2">User List</h5>
                    </div>
                    <div class="card-footer d-flex align-items-center justify-content-between">
                        <a class="text-white stretched-link" href="userlist.php">View Details</a>
                        <i class="fas fa-angle-right"></i>
                    </div>
                </div>
            </div>

            <!-- Logo Settings -->
            <div class="col-xl-3 col-md-6 col-12 mb-4">
                <div class="card bg-gradient-secondary text-white">
                    <div class="card-body py-4">
                        <i class="fas fa-image fa-2x mb-2"></i>
                        <h5 class="mt-2">Logo Settings</h5>
                    </div>
                    <div class="card-footer d-flex align-items-center justify-content-between">
                        <a class="text-white stretched-link" href="logo.php">View Details</a>
                        <i class="fas fa-angle-right"></i>
                    </div>
                </div>
            </div>

        </div>
    </div>
</main>

<br>
<br>


<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/js/bootstrap.bundle.min.js" crossorigin="anonymous"></script>
<script src="js/scripts.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/Chart.js/2.8.0/Chart.min.js" crossorigin="anonymous"></script>
<script src="assets/demo/chart-area-demo.js"></script>
<script src="assets/demo/chart-bar-demo.js"></script>
<script src="https://cdn.jsdelivr.net/npm/simple-datatables@7.1.2/dist/umd/simple-datatables.min.js" crossorigin="anonymous"></script>
<script src="js/datatables-simple-demo.js"></script>
<script>
    function toggleNotifications() {
        const panel = document.getElementById('notification-panel');
        panel.style.display = 'block';
        setTimeout(() => {
            panel.style.display = 'none';
        }, 10000);
    }

    function closeNotifications() {
        document.getElementById('notification-panel').style.display = 'none';
    }
</script>
</body>
</html>
