<?php
// Enable error reporting for debugging
error_reporting(E_ALL);
ini_set('display_errors', 1);
ini_set('log_errors', 1);

// Database configuration - MUST UPDATE THESE VALUES
$dbConfig = [
    'host'      => 'localhost',
    'username'  => 'loannowl_loan1',      // আপনার ডাটাবেস ইউজারনেম
    'password'  => 'loannowl_loan1',    // আপনার ডাটাবেস পাসওয়ার্ড
    'name'      => 'loannowl_loan1',   // আপনার ডাটাবেস নাম
    'charset'   => 'utf8mb4'
];

try {
    // Create database connection
    $conn = new mysqli(
        $dbConfig['host'],
        $dbConfig['username'],
        $dbConfig['password'],
        $dbConfig['name']
    );

    // Check connection
    if ($conn->connect_error) {
        throw new Exception("ডাটাবেস কানেকশন ব্যর্থ: " . $conn->connect_error);
    }

    // Set charset
    if (!$conn->set_charset($dbConfig['charset'])) {
        throw new Exception("ক্যারেক্টার সেট লোড করতে সমস্যা: " . $conn->error);
    }

    // Set Bangladesh timezone
    $conn->query("SET time_zone = '+06:00'");

} catch (Exception $e) {
    // Log error to file
    error_log("[".date('Y-m-d H:i:s')."] Database Error: ".$e->getMessage());
    
    // Show user-friendly message
    die("সিস্টেমে সাময়িক সমস্যা হচ্ছে। অনুগ্রহ করে কিছুক্ষণ পর আবার চেষ্টা করুন।");
}

// Close connection function
function closeDatabaseConnection() {
    global $conn;
    if (isset($conn) && $conn instanceof mysqli) {
        $conn->close();
    }
}

// Register shutdown function
register_shutdown_function('closeDatabaseConnection');
?>