<?php
session_start();
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
// Check if the admin is logged in
if (!isset($_SESSION['adminLogin']) || $_SESSION['adminLogin'] !== true) {
    header("Location:./login.php");
    exit();
}

include ('includes/connect.php');
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Get form data
    $depositOrWidth = $_POST['depositOrWidth'];
    $uid = $_POST['uid'];
    $massage = $_POST['Massage'];
    $status = $_POST['status']; // You might need to set the "name" attribute of this select field to "status"

    if ($depositOrWidth=="Deposit"){
        $stmt = $conn->prepare("INSERT INTO `deposite` (`uid`, `massage`, `status`) VALUES (?, ?, ?)");
        $stmt->bind_param("iss", $uid, $massage, $status);

        if ($stmt->execute()) {
            $_SESSION['status'] = "Deposit successfully inserted.";
        } else {
            $_SESSION['status'] = "Error: " . $stmt->error;
        }

        $stmt->close();

    }else{
        $stmt = $conn->prepare("INSERT INTO `withdraw` (`uid`, `massage`, `status`) VALUES (?, ?, ?)");
        $stmt->bind_param("iss", $uid, $massage, $status);

        if ($stmt->execute()) {
            $_SESSION['status'] = "withdraw Add successfully .";
        } else {
            $_SESSION['status'] = "Error: " . $stmt->error;
        }

        $stmt->close();

    }

    header("Location:depositOrWidth.php?id=".$uid);
    exit();
}

include ('includes/header.php');
echo '<title>depositOrWidth</title>';
include ('includes/topbar.php');
include ('includes/sidebar.php');
?>


<main>
    <div class="container-fluid px-4">
        <h1 class="mt-4">Deposit</h1>

        <?php if (isset($_SESSION['status'])): ?>
            <div class="alert alert-info">
                <?php
                echo $_SESSION['status'];
                unset($_SESSION['status']);
                ?>
            </div>
        <?php endif; ?>
        <ol class="breadcrumb mb-4">
            <li class="breadcrumb-item active">Dashboard</li>
        </ol>
        <div class="container mt-5">
            <h2>Deposit and Pending Deposit and withdraw  and Pending withdraw </h2>
            <form action="depositOrWidth.php" method="POST">
                <select class="form-select form-select-lg mb-3" name="depositOrWidth">
                    <option value="Deposit">Deposit</option>
                    <option value="withdraw ">withdraw </option>
                </select>

                <div class="form-group">
                    <label for="uid">User id</label>
                    <input type="number" class="form-control" id="uid" name="uid" required>
                </div>




                <div class="form-group">
                    <label for="Massage">Massage:</label>
                    <input type="text" class="form-control" id="Massage" name="Massage" required>
                </div>

                <div class="form-group">
                    <div class="mb-3">
                        <label for="basicSelect" class="form-label">Select an option</label>
                        <select class="form-select" id="basicSelect" name="status">

                            <option value="Approved">Approved</option>
                            <option value="Reject">Reject</option>
                            <option value="Pending">Pending</option>
                            <option value="Confirm">Pending</option>
                        </select>
                    </div>

                </div>




                <button type="submit" class="btn btn-primary">Submit</button>
            </form>
        </div>
    </div>
</main>




<?php

include ('includes/footer.php');


?>


<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/js/bootstrap.bundle.min.js" crossorigin="anonymous"></script>
<script src="js/scripts.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/Chart.js/2.8.0/Chart.min.js" crossorigin="anonymous"></script>
<script src="assets/demo/chart-area-demo.js"></script>
<script src="assets/demo/chart-bar-demo.js"></script>
<script src="https://cdn.jsdelivr.net/npm/simple-datatables@7.1.2/dist/umd/simple-datatables.min.js" crossorigin="anonymous"></script>
<script src="js/datatables-simple-demo.js"></script>
</body>
</html>
