<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
// Include database connection
include ('includes/connect.php');


// Check if deposit_id is passed via POST
if (isset($_POST['deposit_id'])) {
    $depositId = $_POST['deposit_id'];

    // SQL query to delete the deposit record from the deposits table
    $sql = "DELETE FROM `deposits` WHERE `id` = ?";

    // Prepare the statement
    if ($stmt = $conn->prepare($sql)) {
        // Bind the deposit_id parameter
        $stmt->bind_param("i", $depositId);
        
        // Execute the query
        if ($stmt->execute()) {
            // Successfully deleted, return success response
            echo "Deposit deleted successfully.";
        } else {
            // Error occurred, return error response
            echo "Error: " . $stmt->error;
        }
        
        // Close the prepared statement
        $stmt->close();
    } else {
        // If preparation fails, return an error
        echo "Error preparing the query.";
    }
}

// Close the database connection
$conn->close();
?>
